/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4Util;
import org.openeuler.sm4.StreamModeBaseCipher;

public class CBC
extends StreamModeBaseCipher {
    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return 0;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        if (outputOffset + this.len > output.length) {
            throw new ShortBufferException();
        }
        if (this.opmode == 1) {
            this.encryptCBC(input, inputOffset, this.len, output, outputOffset);
        } else if (this.opmode == 2) {
            this.decryptCBC(input, inputOffset, this.len, output, outputOffset);
        }
        return this.len;
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return null;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        byte[] res = null;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        res = new byte[this.len];
        if (this.opmode == 1) {
            this.encryptCBC(input, inputOffset, this.len, res, 0);
        } else if (this.opmode == 2) {
            this.decryptCBC(input, inputOffset, this.len, res, 0);
        }
        return res;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] res = null;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && (this.inputLenUpdate - this.len + inputLen) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            int length = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            res = new byte[length];
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0);
            } else if (restLen == 16) {
                this.encryptCBC(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, res, 0);
                this.encrypt(input, inputOffset, inputLen, res, 16);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                this.encrypt(block, 0, block.length, res, 0);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.encryptCBC(block, 0, 16, res, 0);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, res, 16);
            }
        } else if (this.opmode == 2) {
            if ((inputLen + this.inputLenUpdate - this.len) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            if (restLen == 0) {
                if (inputLen == 0) {
                    this.reset();
                    return res;
                }
                res = this.decryptLastBlock(input, inputOffset, inputLen, 0, null);
                this.decryptCBC(input, inputOffset, inputLen - 16, res, 0);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    res = this.decryptLastBlock(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, 0, null);
                } else {
                    res = inputLen == 16 ? this.decryptLastBlock(input, inputOffset, inputLen, 16, Arrays.copyOfRange(this.inputUpdate, this.inputOffsetUpdate + this.len, this.inputOffsetUpdate + this.len + 16)) : this.decryptLastBlock(input, inputOffset, inputLen, 16, null);
                    this.decryptCBC(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, res, 0);
                    this.decryptCBC(input, inputOffset, inputLen - 16, res, 16);
                }
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                if (inputLen == 16 - restLen) {
                    res = this.decryptLastBlock(block, 0, 16, 0, null);
                } else {
                    res = inputLen - 16 + restLen == 16 ? this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16, block) : this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16, null);
                    this.decryptCBC(block, 0, 16, res, 0);
                    this.decryptCBC(input, inputOffset + 16 - restLen, inputLen - 32 + restLen, res, 16);
                }
            }
        }
        this.reset();
        return res;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        int restLen = this.inputLenUpdate - this.len;
        int need = 0;
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && (this.inputLenUpdate - this.len + inputLen) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            need = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, output, outputOffset);
            } else if (restLen == 16) {
                this.encryptCBC(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, output, outputOffset);
                this.encrypt(input, inputOffset, inputLen, output, 16 + outputOffset);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                byte[] fill = this.padding.fill(block);
                this.encrypt(block, 0, 16, output, outputOffset);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.encryptCBC(block, 0, 16, output, outputOffset);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, output, outputOffset + 16);
            }
        } else if (this.opmode == 2) {
            if ((inputLen + this.inputLenUpdate - this.len) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            if (restLen == 0) {
                if (inputLen == 0) {
                    return 0;
                }
                need = this.decryptLastBlock(input, inputOffset, inputLen, 0, output, outputOffset, null);
                this.decryptCBC(input, inputOffset, inputLen - 16, output, outputOffset);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    need = this.decryptLastBlock(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, 0, output, outputOffset, null);
                } else {
                    need = inputLen == 16 ? this.decryptLastBlock(input, inputOffset, inputLen, 16, output, outputOffset, Arrays.copyOfRange(this.inputUpdate, this.inputOffsetUpdate + this.len, this.inputOffsetUpdate + this.len + 16)) : this.decryptLastBlock(input, inputOffset, inputLen, 16, output, outputOffset, null);
                    this.decryptCBC(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, output, outputOffset);
                    this.decryptCBC(input, inputOffset, inputLen - 16, output, outputOffset + 16);
                }
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                if (inputLen == 16 - restLen) {
                    need = this.decryptLastBlock(block, 0, 16, 0, output, outputOffset, null);
                } else {
                    need = inputLen - 16 + restLen == 16 ? this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16, output, outputOffset, block) : this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16, output, outputOffset, null);
                    this.decryptCBC(block, 0, 16, output, outputOffset);
                    this.decryptCBC(input, inputOffset + 16 - restLen, inputLen - 32 + restLen, output, outputOffset + 16);
                }
            }
        }
        this.reset();
        return need;
    }

    private byte[] decryptLastBlock(byte[] input, int inputOffset, int inputLen, int extra, byte[] cipher) throws BadPaddingException {
        byte[] res;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            res = new byte[inputLen + extra];
            if (inputLen == 16) {
                byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
                byte[] xor = null;
                xor = cipher == null ? this.sm4.xor(decrypt, this.counter) : this.sm4.xor(decrypt, cipher);
                SM4Util.copyArray(xor, 0, xor.length, res, res.length - 16);
            } else {
                byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
                byte[] xor = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
                SM4Util.copyArray(xor, 0, xor.length, res, res.length - 16);
            }
        } else if (inputLen == 16) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
            byte[] xor = null;
            xor = cipher == null ? this.sm4.xor(decrypt, this.counter) : this.sm4.xor(decrypt, cipher);
            byte[] recover = this.padding.recover(xor);
            res = new byte[recover.length + extra];
            SM4Util.copyArray(recover, 0, recover.length, res, res.length - recover.length);
        } else {
            byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
            byte[] last128BitPlainTextWithPadding = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
            byte[] lastNoPaddingPlainText = this.padding.recover(last128BitPlainTextWithPadding);
            res = new byte[inputLen - 16 + lastNoPaddingPlainText.length + extra];
            SM4Util.copyArray(lastNoPaddingPlainText, 0, lastNoPaddingPlainText.length, res, res.length - lastNoPaddingPlainText.length);
        }
        return res;
    }

    private int decryptLastBlock(byte[] input, int inputOffset, int inputLen, int extra, byte[] output, int outputOffset, byte[] cipher) throws BadPaddingException, ShortBufferException {
        int need = 0;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            need = inputLen + extra;
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            if (inputLen == 16) {
                byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
                byte[] xor = null;
                xor = cipher == null ? this.sm4.xor(decrypt, this.counter) : this.sm4.xor(decrypt, cipher);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + need - 16);
            } else {
                byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
                byte[] xor = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + need - 16);
            }
        } else if (inputLen == 16) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
            byte[] xor = null;
            xor = cipher == null ? this.sm4.xor(decrypt, this.counter) : this.sm4.xor(decrypt, cipher);
            byte[] recover = this.padding.recover(xor);
            need = recover.length + extra;
            SM4Util.copyArray(recover, 0, recover.length, output, outputOffset + need - recover.length);
        } else {
            byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
            byte[] last128BitPlainTextWithPadding = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
            byte[] lastNoPaddingPlainText = this.padding.recover(last128BitPlainTextWithPadding);
            need = inputLen - 16 + lastNoPaddingPlainText.length + extra;
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            SM4Util.copyArray(lastNoPaddingPlainText, 0, lastNoPaddingPlainText.length, output, outputOffset + need - lastNoPaddingPlainText.length);
        }
        return need;
    }

    private void decryptCBC(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputOffset + inputLen) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
            byte[] xor = this.sm4.xor(decrypt, this.counter);
            SM4Util.copyArray(input, i, 16, this.counter, 0);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        byte[] encrypt;
        byte[] xor;
        int i;
        int limitOffset = inputOffset + inputLen - 16;
        int baseOffset = outputOffset - inputOffset;
        for (i = inputOffset; i <= limitOffset; i += 16) {
            byte[] xor2 = this.sm4.xor(this.counter, 0, this.counter.length, input, i, 16);
            byte[] encrypt2 = this.sm4.encrypt(this.rk, xor2);
            this.counter = encrypt2;
            SM4Util.copyArray(encrypt2, 0, encrypt2.length, output, baseOffset + i);
        }
        if (inputLen % 16 != 0) {
            byte[] fill = this.padding.fill(input, i, inputLen % 16);
            xor = this.sm4.xor(this.counter, fill);
            encrypt = this.sm4.encrypt(this.rk, xor);
            this.counter = encrypt;
            SM4Util.copyArray(encrypt, 0, encrypt.length, output, baseOffset + i);
        }
        if (inputLen % 16 == 0 && !this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] block = new byte[16];
            Arrays.fill(block, (byte)16);
            xor = this.sm4.xor(this.counter, block);
            encrypt = this.sm4.encrypt(this.rk, xor);
            this.counter = encrypt;
            SM4Util.copyArray(encrypt, 0, encrypt.length, output, baseOffset + i);
        }
    }

    private void encryptCBC(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int limitOffset = inputOffset + inputLen - 16;
        int baseOffset = outputOffset - inputOffset;
        for (int i = inputOffset; i <= limitOffset; i += 16) {
            byte[] xor = this.sm4.xor(this.counter, 0, this.counter.length, input, i, 16);
            byte[] encrypt = this.sm4.encrypt(this.rk, xor);
            this.counter = encrypt;
            SM4Util.copyArray(encrypt, 0, encrypt.length, output, baseOffset + i);
        }
    }

    @Override
    public void reset() {
        super.reset();
        SM4Util.copyArray(this.iv, 0, this.iv.length, this.counter, 0);
    }
}

