/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.core.v3.replication;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.opengauss.copy.CopyDual;
import org.opengauss.core.PGStream;
import org.opengauss.core.QueryExecutor;
import org.opengauss.core.ReplicationProtocol;
import org.opengauss.core.v3.replication.V3PGReplicationStream;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.replication.PGReplicationStream;
import org.opengauss.replication.ReplicationType;
import org.opengauss.replication.fluent.CommonOptions;
import org.opengauss.replication.fluent.logical.LogicalReplicationOptions;
import org.opengauss.replication.fluent.physical.PhysicalReplicationOptions;
import org.opengauss.util.GT;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private static Log LOGGER = Logger.getLogger(V3ReplicationProtocol.class.getName());
    private final QueryExecutor queryExecutor;
    private final PGStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, PGStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pgStream;
    }

    @Override
    public PGReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public PGReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL);
    }

    private PGReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType) throws SQLException {
        LOGGER.trace(" FE=> StartReplication(query: " + query + ")");
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3PGReplicationStream(copyDual, options.getStartLSNPosition(), options.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws PSQLException {
        if (options.getStatusInterval() == 0) {
            return;
        }
        try {
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            int minimalTimeOut = previousTimeOut > 0 ? Math.min(previousTimeOut, options.getStatusInterval()) : options.getStatusInterval();
            this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

