/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.spi.reactors.ReactorManager;

class TestClassRunnerForParameters
extends BlockJUnit4ClassRunner {
    private final Object[] fParameters;
    private final String fName;

    TestClassRunnerForParameters(Class<?> type, Object[] parameters, String name) throws InitializationError {
        super(type);
        this.fParameters = parameters;
        this.fName = name;
    }

    public Object createTest() throws Exception {
        Object test = null;
        test = this.fieldsAreAnnotated() ? this.createTestUsingFieldInjection() : this.createTestUsingConstructorInjection();
        ReactorManager.getInstance().inject(test);
        return test;
    }

    private Object createTestUsingConstructorInjection() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
    }

    private Object createTestUsingFieldInjection() throws Exception {
        List<FrameworkField> annotatedFieldsByParameter = this.getAnnotatedFieldsByParameter();
        if (annotatedFieldsByParameter.size() != this.fParameters.length) {
            throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.fParameters.length + ".");
        }
        Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
        for (FrameworkField each : annotatedFieldsByParameter) {
            Field field = each.getField();
            Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
            int index = annotation.value();
            try {
                field.set(testClassInstance, this.fParameters[index]);
            }
            catch (IllegalArgumentException iare) {
                throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.fParameters[index] + " that is not the right type (" + this.fParameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
            }
        }
        return testClassInstance;
    }

    protected String getName() {
        return this.fName;
    }

    protected String testName(FrameworkMethod method) {
        return method.getName() + this.getName();
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        if (this.fieldsAreAnnotated()) {
            this.validateZeroArgConstructor(errors);
        }
    }

    protected void validateFields(List<Throwable> errors) {
        super.validateFields(errors);
        if (this.fieldsAreAnnotated()) {
            List<FrameworkField> annotatedFieldsByParameter = this.getAnnotatedFieldsByParameter();
            int[] usedIndices = new int[annotatedFieldsByParameter.size()];
            for (FrameworkField each : annotatedFieldsByParameter) {
                int index = each.getField().getAnnotation(Parameterized.Parameter.class).value();
                if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                    errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                    continue;
                }
                int n = index;
                usedIndices[n] = usedIndices[n] + 1;
            }
            for (int index = 0; index < usedIndices.length; ++index) {
                int numberOfUse = usedIndices[index];
                if (numberOfUse == 0) {
                    errors.add(new Exception("@Parameter(" + index + ") is never used."));
                    continue;
                }
                if (numberOfUse <= 1) continue;
                errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
            }
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    protected Annotation[] getRunnerAnnotations() {
        return new Annotation[0];
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }
}

