/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.AbstractConfigFilter;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;

public class Saml2MetadataFilter
extends AbstractConfigFilter {
    private String clientName;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.clientName = this.getStringParam(filterConfig, "clientName", this.clientName);
    }

    @Override
    protected void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"config", (Object)this.getSharedConfig());
        CommonHelper.assertNotNull((String)"clientName", (Object)this.clientName);
        Optional result = this.getSharedConfig().getClients().findClient(this.clientName);
        if (!result.isPresent()) {
            throw new TechnicalException("No SAML2 client: " + this.clientName);
        }
        SAML2Client client = (SAML2Client)result.get();
        client.init();
        response.getWriter().write(client.getServiceProviderMetadataResolver().getMetadata());
        response.getWriter().flush();
    }

    @Override
    public void destroy() {
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }
}

