/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2LogoutResponseBuilder {
    private String bindingType;
    private int issueInstantSkewSeconds = 0;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public SAML2LogoutResponseBuilder(String bindingType) {
        this.bindingType = bindingType;
    }

    public LogoutResponse build(SAML2MessageContext context) {
        SingleLogoutService ssoService = context.getIDPSingleLogoutService(this.bindingType);
        return this.buildLogoutResponse(context, ssoService);
    }

    protected final LogoutResponse buildLogoutResponse(SAML2MessageContext context, SingleLogoutService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        LogoutResponse response = (LogoutResponse)builder.buildObject();
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        response.setID(SAML2Utils.generateID());
        response.setIssuer(this.getIssuer(selfContext.getEntityId()));
        response.setIssueInstant(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(this.issueInstantSkewSeconds));
        response.setVersion(SAMLVersion.VERSION_20);
        response.setDestination(ssoService.getLocation());
        response.setStatus(this.getSuccess());
        return response;
    }

    protected Status getSuccess() {
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = (Status)statusBuilder.buildObject();
        StatusCode statusCode = new StatusCodeBuilder().buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        return status;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

