/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.storage;

import java.util.LinkedHashMap;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionStorage
implements SAMLMessageStorage {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebContext context;
    private LinkedHashMap<String, XMLObject> internalMessages;
    private static final String SAML_STORAGE_KEY = "_springSamlStorageKey";

    public HttpSessionStorage(WebContext context) {
        CommonHelper.assertNotNull((String)"context", (Object)context);
        this.context = context;
    }

    @Override
    public void storeMessage(String messageID, XMLObject message) {
        this.log.debug("Storing message {} to session {}", (Object)messageID, (Object)this.context.getSessionStore().getOrCreateSessionId(this.context));
        LinkedHashMap<String, XMLObject> messages = this.getMessages();
        messages.put(messageID, message);
        this.updateSession(messages);
    }

    @Override
    public XMLObject retrieveMessage(String messageID) {
        LinkedHashMap<String, XMLObject> messages = this.getMessages();
        XMLObject o = messages.get(messageID);
        if (o == null) {
            this.log.debug("Message {} not found in session {}", (Object)messageID, (Object)this.context.getSessionStore().getOrCreateSessionId(this.context));
            return null;
        }
        this.log.debug("Message {} found in session {}, clearing", (Object)messageID, (Object)this.context.getSessionStore().getOrCreateSessionId(this.context));
        messages.clear();
        this.updateSession(messages);
        return o;
    }

    private LinkedHashMap<String, XMLObject> getMessages() {
        if (this.internalMessages == null) {
            this.internalMessages = this.initializeSession();
        }
        return this.internalMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, XMLObject> initializeSession() {
        LinkedHashMap<String, XMLObject> messages = (LinkedHashMap<String, XMLObject>)this.context.getSessionStore().get(this.context, SAML_STORAGE_KEY);
        if (messages == null) {
            WebContext webContext = this.context;
            synchronized (webContext) {
                messages = (LinkedHashMap)this.context.getSessionStore().get(this.context, SAML_STORAGE_KEY);
                if (messages == null) {
                    messages = new LinkedHashMap<String, XMLObject>();
                    this.updateSession(messages);
                }
            }
        }
        return messages;
    }

    private void updateSession(LinkedHashMap<String, XMLObject> messages) {
        this.context.getSessionStore().set(this.context, SAML_STORAGE_KEY, messages);
    }
}

