/*
 * Decompiled with CFR 0.152.
 */
package lombok.launch;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import lombok.launch.Main;

public class Delombok {
    private final Object delombokInstance;
    private final Method addDirectory;
    private final Method delombok;
    private final Method formatOptionsToMap;
    private final Method setVerbose;
    private final Method setCharset;
    private final Method setClasspath;
    private final Method setFormatPreferences;
    private final Method setOutput;
    private final Method setSourcepath;

    public Delombok() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        ClassLoader shadowClassLoader = Main.createShadowClassLoader();
        Class<?> delombokClass = shadowClassLoader.loadClass("lombok.delombok.Delombok");
        this.delombokInstance = delombokClass.newInstance();
        this.addDirectory = delombokClass.getMethod("addDirectory", File.class);
        this.delombok = delombokClass.getMethod("delombok", new Class[0]);
        this.formatOptionsToMap = delombokClass.getMethod("formatOptionsToMap", List.class);
        this.setVerbose = delombokClass.getMethod("setVerbose", Boolean.TYPE);
        this.setCharset = delombokClass.getMethod("setCharset", String.class);
        this.setClasspath = delombokClass.getMethod("setClasspath", String.class);
        this.setFormatPreferences = delombokClass.getMethod("setFormatPreferences", Map.class);
        this.setOutput = delombokClass.getMethod("setOutput", File.class);
        this.setSourcepath = delombokClass.getMethod("setSourcepath", String.class);
    }

    public void addDirectory(File base) throws IllegalAccessException, IOException, InvocationTargetException {
        this.addDirectory.invoke(this.delombokInstance, base);
    }

    public boolean delombok() throws IllegalAccessException, IOException, InvocationTargetException {
        return Boolean.parseBoolean(this.delombok.invoke(this.delombokInstance, new Object[0]).toString());
    }

    public Map<String, String> formatOptionsToMap(List<String> formatOptions) throws Exception {
        return (Map)this.formatOptionsToMap.invoke(null, formatOptions);
    }

    public void setVerbose(boolean verbose) throws IllegalAccessException, InvocationTargetException {
        this.setVerbose.invoke(this.delombokInstance, verbose);
    }

    public void setCharset(String charset) throws IllegalAccessException, InvocationTargetException {
        this.setCharset.invoke(this.delombokInstance, charset);
    }

    public void setClasspath(String classpath) throws IllegalAccessException, InvocationTargetException {
        this.setClasspath.invoke(this.delombokInstance, classpath);
    }

    public void setFormatPreferences(Map<String, String> prefs) throws IllegalAccessException, InvocationTargetException {
        this.setFormatPreferences.invoke(this.delombokInstance, prefs);
    }

    public void setOutput(File dir) throws IllegalAccessException, InvocationTargetException {
        this.setOutput.invoke(this.delombokInstance, dir);
    }

    public void setSourcepath(String sourcepath) throws IllegalAccessException, InvocationTargetException {
        this.setSourcepath.invoke(this.delombokInstance, sourcepath);
    }
}

