/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.rythmengine.extension.ILoggerFactory;
import org.rythmengine.logger.ILogger;

public class JDKLogger
implements ILogger {
    private static final long serialVersionUID = 1L;
    protected final Logger logger;
    protected final String className;
    public static boolean firstCall = true;

    public JDKLogger(Class c) {
        this.className = c.getName();
        this.logger = Logger.getLogger(this.className);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String msg, Object ... arg) {
        this.log(Level.FINEST, msg, arg);
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arg) {
        this.log(Level.FINEST, t, msg, arg);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String msg, Object ... arg) {
        this.log(Level.FINE, msg, arg);
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arg) {
        this.log(Level.FINE, t, msg, arg);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg, Object ... arg) {
        this.log(Level.INFO, msg, arg);
    }

    @Override
    public void info(Throwable t, String msg, Object ... arg) {
        this.log(Level.INFO, t, msg, arg);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg, Object ... arg) {
        this.log(Level.WARNING, msg, arg);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arg) {
        this.log(Level.WARNING, t, format, arg);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arg) {
        this.log(Level.SEVERE, format, arg);
    }

    @Override
    public void error(Throwable t, String msg, Object ... arg) {
        this.log(Level.SEVERE, t, msg, arg);
    }

    protected void log(Level l, Throwable t, String m, Object ... a) {
        if (this.logger.isLoggable(l)) {
            try {
                m = String.format(m, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logp(l, this.className, null, m, t);
        }
    }

    protected void log(Level l, String m, Object ... a) {
        if (this.logger.isLoggable(l)) {
            try {
                m = String.format(m, a);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logp(l, this.className, null, m);
        }
    }

    public static class Factory
    implements ILoggerFactory {
        @Override
        public ILogger getLogger(Class<?> clazz) {
            return new JDKLogger(clazz);
        }
    }
}

