/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v104.backgroundservice.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v104.backgroundservice.model.EventMetadata;
import org.openqa.selenium.devtools.v104.backgroundservice.model.ServiceName;
import org.openqa.selenium.devtools.v104.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v104.serviceworker.model.RegistrationID;
import org.openqa.selenium.json.JsonInput;

public class BackgroundServiceEvent {
    private final TimeSinceEpoch timestamp;
    private final String origin;
    private final RegistrationID serviceWorkerRegistrationId;
    private final ServiceName service;
    private final String eventName;
    private final String instanceId;
    private final List<EventMetadata> eventMetadata;

    public BackgroundServiceEvent(TimeSinceEpoch timestamp, String origin, RegistrationID serviceWorkerRegistrationId, ServiceName service, String eventName, String instanceId, List<EventMetadata> eventMetadata) {
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.serviceWorkerRegistrationId = Objects.requireNonNull(serviceWorkerRegistrationId, "serviceWorkerRegistrationId is required");
        this.service = Objects.requireNonNull(service, "service is required");
        this.eventName = Objects.requireNonNull(eventName, "eventName is required");
        this.instanceId = Objects.requireNonNull(instanceId, "instanceId is required");
        this.eventMetadata = Objects.requireNonNull(eventMetadata, "eventMetadata is required");
    }

    public TimeSinceEpoch getTimestamp() {
        return this.timestamp;
    }

    public String getOrigin() {
        return this.origin;
    }

    public RegistrationID getServiceWorkerRegistrationId() {
        return this.serviceWorkerRegistrationId;
    }

    public ServiceName getService() {
        return this.service;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<EventMetadata> getEventMetadata() {
        return this.eventMetadata;
    }

    private static BackgroundServiceEvent fromJson(JsonInput input) {
        TimeSinceEpoch timestamp = null;
        String origin = null;
        RegistrationID serviceWorkerRegistrationId = null;
        ServiceName service = null;
        String eventName = null;
        String instanceId = null;
        List eventMetadata = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block18;
                }
                case "serviceWorkerRegistrationId": {
                    serviceWorkerRegistrationId = (RegistrationID)input.read(RegistrationID.class);
                    continue block18;
                }
                case "service": {
                    service = (ServiceName)((Object)input.read(ServiceName.class));
                    continue block18;
                }
                case "eventName": {
                    eventName = input.nextString();
                    continue block18;
                }
                case "instanceId": {
                    instanceId = input.nextString();
                    continue block18;
                }
                case "eventMetadata": {
                    eventMetadata = (List)input.read(new TypeToken<List<EventMetadata>>(){}.getType());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BackgroundServiceEvent(timestamp, origin, serviceWorkerRegistrationId, service, eventName, instanceId, eventMetadata);
    }
}

