/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.storage.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v115.page.model.FrameId;
import org.openqa.selenium.devtools.v115.storage.model.SharedStorageAccessParams;
import org.openqa.selenium.devtools.v115.storage.model.SharedStorageAccessType;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageAccessed {
    private final TimeSinceEpoch accessTime;
    private final SharedStorageAccessType type;
    private final FrameId mainFrameId;
    private final String ownerOrigin;
    private final SharedStorageAccessParams params;

    public SharedStorageAccessed(TimeSinceEpoch accessTime, SharedStorageAccessType type, FrameId mainFrameId, String ownerOrigin, SharedStorageAccessParams params) {
        this.accessTime = Objects.requireNonNull(accessTime, "accessTime is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.mainFrameId = Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.params = Objects.requireNonNull(params, "params is required");
    }

    public TimeSinceEpoch getAccessTime() {
        return this.accessTime;
    }

    public SharedStorageAccessType getType() {
        return this.type;
    }

    public FrameId getMainFrameId() {
        return this.mainFrameId;
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    public SharedStorageAccessParams getParams() {
        return this.params;
    }

    private static SharedStorageAccessed fromJson(JsonInput input) {
        TimeSinceEpoch accessTime = null;
        SharedStorageAccessType type = null;
        FrameId mainFrameId = null;
        String ownerOrigin = null;
        SharedStorageAccessParams params = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "accessTime": {
                    accessTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block14;
                }
                case "type": {
                    type = (SharedStorageAccessType)((Object)input.read(SharedStorageAccessType.class));
                    continue block14;
                }
                case "mainFrameId": {
                    mainFrameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block14;
                }
                case "params": {
                    params = (SharedStorageAccessParams)input.read(SharedStorageAccessParams.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageAccessed(accessTime, type, mainFrameId, ownerOrigin, params);
    }
}

