/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.input.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum GestureSourceType {
    DEFAULT("default"),
    TOUCH("touch"),
    MOUSE("mouse");

    private String value;

    private GestureSourceType(String value) {
        this.value = value;
    }

    public static GestureSourceType fromString(String s) {
        return Arrays.stream(GestureSourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within GestureSourceType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static GestureSourceType fromJson(JsonInput input) {
        return GestureSourceType.fromString(input.nextString());
    }
}

