/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.agent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Date;
import java.util.Properties;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.instrumentation.LogTransformer;

public class AgentPremain {
    private static final String START_MSG = "Start at {}";
    private static final String STOP_MSG = "Stop at {}, execution time = {} ms";

    public static void premain(String agentArgument, Instrumentation instrumentation) {
        LogTransformer.Builder builder = new LogTransformer.Builder();
        builder = builder.addEntryExit(true);
        if (agentArgument != null) {
            Properties args = AgentPremain.parseArguments(agentArgument, ",");
            if (args.containsKey("verbose")) {
                builder = builder.verbose(true);
            }
            if (args.containsKey("time")) {
                AgentPremain.printStartStopTimes();
            }
            if (args.containsKey("ignore")) {
                String ignore = args.getProperty("ignore");
                builder = builder.ignore(ignore.split(":"));
            }
            if (args.containsKey("level")) {
                builder = builder.level(args.getProperty("level"));
            }
        }
        instrumentation.addTransformer(builder.build());
    }

    private static Properties parseArguments(String agentArgument, String separator) {
        Properties p = new Properties();
        try {
            String argumentAsLines = agentArgument.replaceAll(separator, "\n");
            p.load(new ByteArrayInputStream(argumentAsLines.getBytes()));
        }
        catch (IOException e) {
            String s = "Could not load arguments as properties";
            throw new RuntimeException(s, e);
        }
        return p;
    }

    private static void printStartStopTimes() {
        final long start = System.currentTimeMillis();
        System.err.println(MessageFormatter.format((String)START_MSG, (Object)new Date()));
        Thread hook = new Thread(){

            public void run() {
                long timePassed = System.currentTimeMillis() - start;
                String message = MessageFormatter.format((String)AgentPremain.STOP_MSG, (Object)new Date(), (Object)timePassed);
                System.err.println(message);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
    }
}

