/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.util;

import java.lang.module.ModuleDescriptor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class VersionUtils {
    private static final String SEQUENCE_SEPARATOR = ".";
    private static final String QUALIFIER_SEPARATOR = "-";

    private VersionUtils() {
    }

    public static boolean isAtLeastIgnoringQualifier(@Nullable String version, String targetVersion) {
        if (VersionUtils.isOfUnexpectedFormat(version)) {
            return false;
        }
        return ModuleDescriptor.Version.parse(StringUtils.substringBefore((String)version, (String)QUALIFIER_SEPARATOR)).compareTo(ModuleDescriptor.Version.parse(targetVersion)) >= 0;
    }

    public static int compareMajor(@Nullable String version, int number) {
        if (VersionUtils.isOfUnexpectedFormat(version)) {
            return Integer.compare(0, number);
        }
        String s = StringUtils.trimToEmpty((String)version);
        String qualifier = StringUtils.substringAfter((String)s, (String)QUALIFIER_SEPARATOR);
        if (!qualifier.isEmpty()) {
            s = StringUtils.substringBefore((String)s, (String)QUALIFIER_SEPARATOR);
        }
        String[] fields = s.split(Pattern.quote(SEQUENCE_SEPARATOR));
        try {
            return Integer.compare(Integer.parseInt(fields[0]), number);
        }
        catch (NumberFormatException e) {
            return Integer.compare(0, number);
        }
    }

    private static boolean isOfUnexpectedFormat(@Nullable String version) {
        return StringUtils.isBlank((CharSequence)version) || String.valueOf(version.trim().charAt(0)).matches("\\D");
    }
}

