/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.error;

import jakarta.servlet.Servlet;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.log.props.BladeLogProperties;
import org.springblade.core.log.publisher.ErrorLogPublisher;
import org.springblade.core.secure.exception.SecureException;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.UrlUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.NoHandlerFoundException;

@AutoConfiguration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@RestControllerAdvice
public class BladeRestExceptionTranslator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BladeRestExceptionTranslator.class);
    private final BladeProperties bladeProperties;
    private final BladeLogProperties bladeLogProperties;

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(MissingServletRequestParameterException e) {
        log.warn("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570", (Object)e.getMessage());
        String message = String.format("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570: %s", e.getParameterName());
        return R.fail((IResultCode)ResultCode.PARAM_MISS, (String)message);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(MethodArgumentTypeMismatchException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Object)e.getMessage());
        String message = String.format("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef: %s", e.getName());
        return R.fail((IResultCode)ResultCode.PARAM_TYPE_ERROR, (String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(MethodArgumentNotValidException e) {
        log.warn("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Object)e.getMessage());
        return this.handleError(e.getBindingResult());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(BindException e) {
        log.warn("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25", (Object)e.getMessage());
        return this.handleError(e.getBindingResult());
    }

    private R handleError(BindingResult result) {
        FieldError error = result.getFieldError();
        String message = String.format("%s:%s", error.getField(), error.getDefaultMessage());
        return R.fail((IResultCode)ResultCode.PARAM_BIND_ERROR, (String)message);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(ConstraintViolationException e) {
        log.warn("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Object)e.getMessage());
        Set violations = e.getConstraintViolations();
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        String path = ((PathImpl)violation.getPropertyPath()).getLeafNode().getName();
        String message = String.format("%s:%s", path, violation.getMessage());
        return R.fail((IResultCode)ResultCode.PARAM_VALID_ERROR, (String)message);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public R handleError(NoHandlerFoundException e) {
        log.error("404\u6ca1\u627e\u5230\u8bf7\u6c42:{}", (Object)e.getMessage());
        return R.fail((IResultCode)ResultCode.NOT_FOUND, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(HttpMessageNotReadableException e) {
        log.error("\u6d88\u606f\u4e0d\u80fd\u8bfb\u53d6:{}", (Object)e.getMessage());
        return R.fail((IResultCode)ResultCode.MSG_NOT_READABLE, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public R handleError(HttpRequestMethodNotSupportedException e) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5:{}", (Object)e.getMessage());
        return R.fail((IResultCode)ResultCode.METHOD_NOT_SUPPORTED, (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public R handleError(HttpMediaTypeNotSupportedException e) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b:{}", (Object)e.getMessage());
        return R.fail((IResultCode)ResultCode.MEDIA_TYPE_NOT_SUPPORTED, (String)e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        return R.fail((IResultCode)e.getResultCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={SecureException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public R handleError(SecureException e) {
        log.error("\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
        return R.fail((IResultCode)e.getResultCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R handleError(Throwable e) {
        log.error("\u670d\u52a1\u5668\u5f02\u5e38", e);
        if (this.bladeLogProperties.getError().booleanValue()) {
            ErrorLogPublisher.publishEvent(e, UrlUtil.getPath((String)WebUtil.getRequest().getRequestURI()));
        }
        if (this.bladeProperties.isProd()) {
            return R.fail((IResultCode)ResultCode.INTERNAL_SERVER_ERROR);
        }
        return R.fail((IResultCode)ResultCode.INTERNAL_SERVER_ERROR, (String)(Func.isEmpty((Object)e.getMessage()) ? ResultCode.INTERNAL_SERVER_ERROR.getMessage() : e.getMessage()));
    }

    @Generated
    public BladeRestExceptionTranslator(BladeProperties bladeProperties, BladeLogProperties bladeLogProperties) {
        this.bladeProperties = bladeProperties;
        this.bladeLogProperties = bladeLogProperties;
    }
}

