/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.model;

import java.util.Arrays;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.StreamingModel;
import reactor.core.publisher.Flux;

@FunctionalInterface
public interface StreamingChatModel
extends StreamingModel<Prompt, ChatResponse> {
    @Override
    default public Flux<String> stream(String message) {
        Prompt prompt = new Prompt(message);
        return this.stream(prompt).map(response -> response.getResult() == null || response.getResult().getOutput() == null || response.getResult().getOutput().getText() == null ? "" : response.getResult().getOutput().getText());
    }

    @Override
    default public Flux<String> stream(Message ... messages) {
        Prompt prompt = new Prompt(Arrays.asList(messages));
        return this.stream(prompt).map(response -> response.getResult() == null || response.getResult().getOutput() == null || response.getResult().getOutput().getText() == null ? "" : response.getResult().getOutput().getText());
    }

    @Override
    public Flux<ChatResponse> stream(Prompt var1);
}

