/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jspecify.annotations.Nullable;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;
import org.springframework.boot.maven.MavenBuildOutputTimestamp;

@Mojo(name="build-info", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class BuildInfoMojo
extends AbstractMojo {
    private final BuildContext buildContext;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/build-info.properties")
    private File outputFile;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private @Nullable String time;
    @Parameter
    private @Nullable Map<String, String> additionalProperties;
    @Parameter
    private @Nullable List<String> excludeInfoProperties;
    @Parameter(property="spring-boot.build-info.skip", defaultValue="false")
    private boolean skip;

    @Inject
    public BuildInfoMojo(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping build-info as per configuration.");
            return;
        }
        try {
            BuildPropertiesWriter.ProjectDetails details = this.getProjectDetails();
            new BuildPropertiesWriter(this.outputFile).writeBuildProperties(details);
            this.buildContext.refresh(this.outputFile);
        }
        catch (BuildPropertiesWriter.NullAdditionalPropertyValueException ex) {
            throw new MojoFailureException("Failed to generate build-info.properties. " + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private BuildPropertiesWriter.ProjectDetails getProjectDetails() {
        String group = this.getIfNotExcluded("group", this.project.getGroupId());
        String artifact = this.getIfNotExcluded("artifact", this.project.getArtifactId());
        String version = this.getIfNotExcluded("version", this.project.getVersion());
        String name = this.getIfNotExcluded("name", this.project.getName());
        Instant time = this.getIfNotExcluded("time", this.getBuildTime());
        Map<String, String> additionalProperties = this.applyExclusions(this.additionalProperties);
        return new BuildPropertiesWriter.ProjectDetails(group, artifact, version, name, time, additionalProperties);
    }

    private <T> @Nullable T getIfNotExcluded(String name, @Nullable T value) {
        return (T)(this.excludeInfoProperties == null || !this.excludeInfoProperties.contains(name) ? value : null);
    }

    private @Nullable Map<String, String> applyExclusions(@Nullable Map<String, String> source) {
        if (source == null || this.excludeInfoProperties == null) {
            return source;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(source);
        this.excludeInfoProperties.forEach(result::remove);
        return result;
    }

    private @Nullable Instant getBuildTime() {
        if (this.time == null || this.time.isEmpty()) {
            Date startTime = this.session.getRequest().getStartTime();
            return startTime != null ? startTime.toInstant() : Instant.now();
        }
        if ("off".equalsIgnoreCase(this.time)) {
            return null;
        }
        return new MavenBuildOutputTimestamp(this.time).toInstant();
    }
}

