/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.source.CachingConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyCaching;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.SoftReferenceConfigurationPropertyCache;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.boot.env.PropertySourceInfo;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

class SpringIterableConfigurationPropertySource
extends SpringConfigurationPropertySource
implements IterableConfigurationPropertySource,
CachingConfigurationPropertySource {
    private final BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> ancestorOfCheck;
    private final SoftReferenceConfigurationPropertyCache<Cache> cache;
    private volatile @Nullable ConfigurationPropertyName @Nullable [] configurationPropertyNames;
    private final @Nullable Map<ConfigurationPropertyName, ConfigurationPropertyState> containsDescendantOfCache;

    SpringIterableConfigurationPropertySource(EnumerablePropertySource<?> propertySource, boolean systemEnvironmentSource, PropertyMapper ... mappers) {
        super((PropertySource<?>)propertySource, systemEnvironmentSource, mappers);
        this.assertEnumerablePropertySource();
        boolean immutable = this.isImmutablePropertySource();
        this.ancestorOfCheck = this.getAncestorOfCheck(mappers);
        this.cache = new SoftReferenceConfigurationPropertyCache(immutable);
        this.containsDescendantOfCache = !systemEnvironmentSource ? null : new ConcurrentReferenceHashMap();
    }

    private BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> getAncestorOfCheck(PropertyMapper[] mappers) {
        BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> ancestorOfCheck = mappers[0].getAncestorOfCheck();
        for (int i = 1; i < mappers.length; ++i) {
            ancestorOfCheck = ancestorOfCheck.or(mappers[i].getAncestorOfCheck());
        }
        return ancestorOfCheck;
    }

    private void assertEnumerablePropertySource() {
        EnumerablePropertySource<?> enumerablePropertySource = this.getPropertySource();
        if (enumerablePropertySource instanceof MapPropertySource) {
            MapPropertySource mapSource = (MapPropertySource)enumerablePropertySource;
            try {
                ((Map)mapSource.getSource()).size();
            }
            catch (UnsupportedOperationException ex) {
                throw new IllegalArgumentException("PropertySource must be fully enumerable");
            }
        }
    }

    @Override
    public ConfigurationPropertyCaching getCaching() {
        return this.cache;
    }

    @Override
    public @Nullable ConfigurationProperty getConfigurationProperty(@Nullable ConfigurationPropertyName name) {
        if (name == null) {
            return null;
        }
        ConfigurationProperty configurationProperty = super.getConfigurationProperty(name);
        if (configurationProperty != null) {
            return configurationProperty;
        }
        for (String candidate : this.getCache().getMapped(name)) {
            Object value = this.getPropertySourceProperty(candidate);
            if (value == null) continue;
            Origin origin = PropertySourceOrigin.get(this.getPropertySource(), candidate);
            return ConfigurationProperty.of(this, name, value, origin);
        }
        return null;
    }

    @Override
    protected @Nullable Object getSystemEnvironmentProperty(Map<String, Object> systemEnvironment, String name) {
        return this.getCache().getSystemEnvironmentProperty(name);
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        @Nullable ConfigurationPropertyName[] names = this.getConfigurationPropertyNames();
        return Arrays.stream(names).filter(Objects::nonNull);
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return new ConfigurationPropertyNamesIterator(this.getConfigurationPropertyNames());
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        Set<ConfigurationPropertyName> descendants;
        ConfigurationPropertyState result = super.containsDescendantOf(name);
        if (result != ConfigurationPropertyState.UNKNOWN) {
            return result;
        }
        if (this.ancestorOfCheck == PropertyMapper.DEFAULT_ANCESTOR_OF_CHECK && (descendants = this.getCache().getDescendants()) != null) {
            if (name.isEmpty() && !descendants.isEmpty()) {
                return ConfigurationPropertyState.PRESENT;
            }
            return !descendants.contains(name) ? ConfigurationPropertyState.ABSENT : ConfigurationPropertyState.PRESENT;
        }
        ConfigurationPropertyState configurationPropertyState = result = this.containsDescendantOfCache != null ? this.containsDescendantOfCache.get(name) : null;
        if (result == null) {
            ConfigurationPropertyState configurationPropertyState2 = result = !this.ancestorOfCheck(name) ? ConfigurationPropertyState.ABSENT : ConfigurationPropertyState.PRESENT;
            if (this.containsDescendantOfCache != null) {
                this.containsDescendantOfCache.put(name, result);
            }
        }
        return result;
    }

    private boolean ancestorOfCheck(ConfigurationPropertyName name) {
        ConfigurationPropertyName[] candidates;
        for (ConfigurationPropertyName candidate : candidates = this.getConfigurationPropertyNames()) {
            if (candidate == null || !this.ancestorOfCheck.test(name, candidate)) continue;
            return true;
        }
        return false;
    }

    @Nullable ConfigurationPropertyName[] getConfigurationPropertyNames() {
        if (!this.isImmutablePropertySource()) {
            return this.getCache().getConfigurationPropertyNames(this.getPropertySource().getPropertyNames());
        }
        @Nullable ConfigurationPropertyName[] configurationPropertyNames = this.configurationPropertyNames;
        if (configurationPropertyNames == null) {
            configurationPropertyNames = this.getCache().getConfigurationPropertyNames(this.getPropertySource().getPropertyNames());
            this.configurationPropertyNames = configurationPropertyNames;
        }
        return configurationPropertyNames;
    }

    private Cache getCache() {
        return this.cache.get(this::createCache, this::updateCache);
    }

    private Cache createCache() {
        boolean immutable = this.isImmutablePropertySource();
        boolean captureDescendants = this.ancestorOfCheck == PropertyMapper.DEFAULT_ANCESTOR_OF_CHECK;
        return new Cache(this.getMappers(), immutable, captureDescendants, this.isSystemEnvironmentSource());
    }

    private Cache updateCache(Cache cache) {
        cache.update(this.getPropertySource());
        return cache;
    }

    boolean isImmutablePropertySource() {
        EnumerablePropertySource<?> source = this.getPropertySource();
        if (source instanceof PropertySourceInfo) {
            PropertySourceInfo propertySourceInfo = (PropertySourceInfo)source;
            return propertySourceInfo.isImmutable();
        }
        if ("systemEnvironment".equals(source.getName())) {
            return source.getSource() == System.getenv();
        }
        return false;
    }

    protected EnumerablePropertySource<?> getPropertySource() {
        return (EnumerablePropertySource)super.getPropertySource();
    }

    private static class Cache {
        private static final ConfigurationPropertyName[] EMPTY_NAMES_ARRAY = new ConfigurationPropertyName[0];
        private final PropertyMapper[] mappers;
        private final boolean immutable;
        private final boolean captureDescendants;
        private final boolean systemEnvironmentSource;
        private volatile @Nullable Data data;

        Cache(PropertyMapper[] mappers, boolean immutable, boolean captureDescendants, boolean systemEnvironmentSource) {
            this.mappers = mappers;
            this.immutable = immutable;
            this.captureDescendants = captureDescendants;
            this.systemEnvironmentSource = systemEnvironmentSource;
        }

        void update(EnumerablePropertySource<?> propertySource) {
            if (this.data == null || !this.immutable) {
                int count = 0;
                while (true) {
                    try {
                        this.tryUpdate(propertySource);
                        return;
                    }
                    catch (ConcurrentModificationException ex) {
                        if (count++ <= 10) continue;
                        throw ex;
                    }
                    break;
                }
            }
        }

        private void tryUpdate(EnumerablePropertySource<?> propertySource) {
            Data data = this.data;
            Object[] lastUpdated = data != null ? data.lastUpdated() : null;
            Object[] propertyNames = propertySource.getPropertyNames();
            if (lastUpdated != null && Arrays.equals(lastUpdated, propertyNames)) {
                return;
            }
            int size = propertyNames.length;
            Map<ConfigurationPropertyName, Set<String>> mappings = this.cloneOrCreate(data != null ? data.mappings() : null, size);
            Map<String, ConfigurationPropertyName> reverseMappings = this.cloneOrCreate(data != null ? data.reverseMappings() : null, size);
            HashSet<ConfigurationPropertyName> descendants = !this.captureDescendants ? null : new HashSet<ConfigurationPropertyName>();
            HashMap<String, Object> systemEnvironmentCopy = !this.systemEnvironmentSource ? null : this.copySource(propertySource);
            for (PropertyMapper propertyMapper : this.mappers) {
                for (Object propertyName : propertyNames) {
                    ConfigurationPropertyName configurationPropertyName;
                    if (reverseMappings.containsKey(propertyName) || (configurationPropertyName = propertyMapper.map((String)propertyName)) == null || configurationPropertyName.isEmpty()) continue;
                    this.add(mappings, configurationPropertyName, propertyName);
                    reverseMappings.put((String)propertyName, configurationPropertyName);
                }
            }
            for (Object propertyName : propertyNames) {
                this.addParents(descendants, reverseMappings.get(propertyName));
            }
            ConfigurationPropertyName[] configurationPropertyNames = this.immutable ? reverseMappings.values().toArray(new ConfigurationPropertyName[0]) : null;
            lastUpdated = this.immutable ? null : propertyNames;
            this.data = new Data(mappings, reverseMappings, descendants, configurationPropertyNames, systemEnvironmentCopy, (String[])lastUpdated);
        }

        private HashMap<String, Object> copySource(EnumerablePropertySource<?> propertySource) {
            return new HashMap<String, Object>((Map)propertySource.getSource());
        }

        private <K, V> Map<K, V> cloneOrCreate(@Nullable Map<K, V> source, int size) {
            return source != null ? new LinkedHashMap<K, V>(source) : new LinkedHashMap(size);
        }

        private void addParents(@Nullable Set<ConfigurationPropertyName> descendants, @Nullable ConfigurationPropertyName name) {
            if (descendants == null || name == null || name.isEmpty()) {
                return;
            }
            ConfigurationPropertyName parent = name.getParent();
            while (!parent.isEmpty()) {
                if (!descendants.add(parent)) {
                    return;
                }
                parent = parent.getParent();
            }
        }

        private <K, T> void add(Map<K, Set<T>> map, K key, T value) {
            map.computeIfAbsent(key, k -> new HashSet()).add(value);
        }

        Set<String> getMapped(ConfigurationPropertyName configurationPropertyName) {
            Data data = this.data;
            Assert.state((data != null ? 1 : 0) != 0, (String)"'data' must not be null");
            return data.mappings().getOrDefault(configurationPropertyName, Collections.emptySet());
        }

        @Nullable ConfigurationPropertyName[] getConfigurationPropertyNames(String[] propertyNames) {
            Data data = this.data;
            Assert.state((data != null ? 1 : 0) != 0, (String)"'data' must not be null");
            @Nullable ConfigurationPropertyName[] names = data.configurationPropertyNames();
            if (names != null) {
                return names;
            }
            Map<String, ConfigurationPropertyName> reverseMappings = data.reverseMappings();
            if (reverseMappings == null || reverseMappings.isEmpty()) {
                return EMPTY_NAMES_ARRAY;
            }
            names = new ConfigurationPropertyName[propertyNames.length];
            for (int i = 0; i < propertyNames.length; ++i) {
                names[i] = reverseMappings.get(propertyNames[i]);
            }
            return names;
        }

        @Nullable Set<ConfigurationPropertyName> getDescendants() {
            Data data = this.data;
            Assert.state((data != null ? 1 : 0) != 0, (String)"'data' must not be null");
            return data.descendants();
        }

        @Nullable Object getSystemEnvironmentProperty(String name) {
            Data data = this.data;
            Assert.state((data != null ? 1 : 0) != 0, (String)"'data' must not be null");
            Map<String, Object> systemEnvironmentCopy = data.systemEnvironmentCopy();
            Assert.state((systemEnvironmentCopy != null ? 1 : 0) != 0, (String)"'systemEnvironmentCopy' must not be null");
            return systemEnvironmentCopy.get(name);
        }

        private record Data(Map<ConfigurationPropertyName, Set<String>> mappings, Map<String, ConfigurationPropertyName> reverseMappings, @Nullable Set<ConfigurationPropertyName> descendants, ConfigurationPropertyName @Nullable [] configurationPropertyNames, @Nullable Map<String, Object> systemEnvironmentCopy, String @Nullable [] lastUpdated) {
        }
    }

    private static class ConfigurationPropertyNamesIterator
    implements Iterator<ConfigurationPropertyName> {
        private final @Nullable ConfigurationPropertyName[] names;
        private int index;

        ConfigurationPropertyNamesIterator(@Nullable ConfigurationPropertyName[] names) {
            this.names = names;
        }

        @Override
        public boolean hasNext() {
            this.skipNulls();
            return this.index < this.names.length;
        }

        @Override
        public @Nullable ConfigurationPropertyName next() {
            this.skipNulls();
            if (this.index >= this.names.length) {
                throw new NoSuchElementException();
            }
            return this.names[this.index++];
        }

        private void skipNulls() {
            while (this.index < this.names.length) {
                if (this.names[this.index] != null) {
                    return;
                }
                ++this.index;
            }
        }
    }
}

