/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class LoggerConfiguration {
    private final String name;
    private final @Nullable LevelConfiguration levelConfiguration;
    private final LevelConfiguration inheritedLevelConfiguration;

    public LoggerConfiguration(String name, @Nullable LogLevel configuredLevel, LogLevel effectiveLevel) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)((Object)effectiveLevel), (String)"'effectiveLevel' must not be null");
        this.name = name;
        this.levelConfiguration = configuredLevel != null ? LevelConfiguration.of(configuredLevel) : null;
        this.inheritedLevelConfiguration = LevelConfiguration.of(effectiveLevel);
    }

    public LoggerConfiguration(String name, @Nullable LevelConfiguration levelConfiguration, LevelConfiguration inheritedLevelConfiguration) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)inheritedLevelConfiguration, (String)"'inheritedLevelConfiguration' must not be null");
        this.name = name;
        this.levelConfiguration = levelConfiguration;
        this.inheritedLevelConfiguration = inheritedLevelConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable LogLevel getConfiguredLevel() {
        LevelConfiguration configuration = this.getLevelConfiguration(ConfigurationScope.DIRECT);
        return configuration != null ? configuration.getLevel() : null;
    }

    public LogLevel getEffectiveLevel() {
        return this.getLevelConfiguration().getLevel();
    }

    public LevelConfiguration getLevelConfiguration() {
        LevelConfiguration result = this.getLevelConfiguration(ConfigurationScope.INHERITED);
        Assert.state((result != null ? 1 : 0) != 0, (String)"Inherited level configuration must not be null");
        return result;
    }

    public @Nullable LevelConfiguration getLevelConfiguration(ConfigurationScope scope) {
        return scope != ConfigurationScope.DIRECT ? this.inheritedLevelConfiguration : this.levelConfiguration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoggerConfiguration other = (LoggerConfiguration)obj;
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name) && ObjectUtils.nullSafeEquals((Object)this.levelConfiguration, (Object)other.levelConfiguration) && ObjectUtils.nullSafeEquals((Object)this.inheritedLevelConfiguration, (Object)other.inheritedLevelConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.levelConfiguration, this.inheritedLevelConfiguration);
    }

    public String toString() {
        return "LoggerConfiguration [name=" + this.name + ", levelConfiguration=" + String.valueOf(this.levelConfiguration) + ", inheritedLevelConfiguration=" + String.valueOf(this.inheritedLevelConfiguration) + "]";
    }

    public static final class LevelConfiguration {
        private final String name;
        private final @Nullable LogLevel logLevel;

        private LevelConfiguration(String name, @Nullable LogLevel logLevel) {
            this.name = name;
            this.logLevel = logLevel;
        }

        public String getName() {
            return this.name;
        }

        public LogLevel getLevel() {
            Assert.state((this.logLevel != null ? 1 : 0) != 0, () -> "Unable to provide LogLevel for '" + this.name + "'");
            return this.logLevel;
        }

        public boolean isCustom() {
            return this.logLevel == null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LevelConfiguration other = (LevelConfiguration)obj;
            return this.logLevel == other.logLevel && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.logLevel, this.name});
        }

        public String toString() {
            return "LevelConfiguration [name=" + this.name + ", logLevel=" + String.valueOf((Object)this.logLevel) + "]";
        }

        public static LevelConfiguration of(LogLevel logLevel) {
            Assert.notNull((Object)((Object)logLevel), (String)"'logLevel' must not be null");
            return new LevelConfiguration(logLevel.name(), logLevel);
        }

        public static LevelConfiguration ofCustom(String name) {
            Assert.hasText((String)name, (String)"'name' must not be empty");
            return new LevelConfiguration(name, null);
        }
    }

    public static enum ConfigurationScope {
        DIRECT,
        INHERITED;

    }
}

