/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NacosDataSourceWithAuthorization<T>
extends AbstractDataSource<String, T> {
    private static final int DEFAULT_TIMEOUT = 3000;
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-nacos-auth-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final Listener configListener;
    private final Properties properties;
    private final String dataId;
    private final String groupId;
    private ConfigService configService = null;

    public NacosDataSourceWithAuthorization(final Properties properties, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: groupId=[%s], dataId=[%s]", groupId, dataId));
        }
        this.groupId = groupId;
        this.dataId = dataId;
        this.properties = properties;
        this.configListener = new Listener(){

            public Executor getExecutor() {
                return NacosDataSourceWithAuthorization.this.pool;
            }

            public void receiveConfigInfo(String configInfo) {
                RecordLog.info((String)String.format("[NacosDataSourceWithAuthorization] New property value received for %s", properties.toString()), (Object[])new Object[0]);
                Object newValue = NacosDataSourceWithAuthorization.this.parser.convert((Object)configInfo);
                NacosDataSourceWithAuthorization.this.getProperty().updateValue(newValue);
            }
        };
        this.initNacosListener();
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[NacosDataSourceWithAuthorization] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[NacosDataSourceWithAuthorization] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initNacosListener() {
        try {
            this.configService = NacosFactory.createConfigService((Properties)this.properties);
            this.configService.addListener(this.dataId, this.groupId, this.configListener);
        }
        catch (Exception e) {
            RecordLog.warn((String)"[NacosDataSourceWithAuthorization] Error occurred when initializing Nacos data source", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String readSource() throws Exception {
        if (this.configService == null) {
            throw new IllegalStateException("Nacos config service has not been initialized or error occurred");
        }
        return this.configService.getConfig(this.dataId, this.groupId, 3000L);
    }

    public void close() {
        if (this.configService != null) {
            this.configService.removeListener(this.dataId, this.groupId, this.configListener);
        }
        this.pool.shutdownNow();
    }
}

