/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.converter;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonConverter
implements Converter<String, List<AbstractRule>> {
    private static final Logger logger = LoggerFactory.getLogger(JsonConverter.class);
    private final ObjectMapper objectMapper;

    public JsonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<AbstractRule> convert(String source) {
        ArrayList<AbstractRule> ruleList = new ArrayList<AbstractRule>();
        if (StringUtils.isEmpty((Object)source)) {
            logger.warn("Sentinel JsonConverter can not convert rules because source is empty");
            return ruleList;
        }
        try {
            List jsonArray = (List)this.objectMapper.readValue(source, (TypeReference)new TypeReference<List<HashMap>>(){});
            jsonArray.stream().forEach(obj -> {
                String itemJson = null;
                try {
                    itemJson = this.objectMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                List<AbstractRule> rules = Arrays.asList(this.convertFlowRule(itemJson), this.convertDegradeRule(itemJson), this.convertSystemRule(itemJson), this.convertAuthorityRule(itemJson), this.convertParamFlowRule(itemJson));
                List convertRuleList = rules.stream().filter(rule -> !ObjectUtils.isEmpty((Object)rule)).collect(Collectors.toList());
                if (convertRuleList.size() == 0) {
                    logger.warn("Sentinel JsonConverter can not convert {} to any rules, ignore", (Object)itemJson);
                } else if (convertRuleList.size() > 1) {
                    logger.warn("Sentinel JsonConverter convert {} and match multi rules, ignore", (Object)itemJson);
                } else {
                    ruleList.add((AbstractRule)convertRuleList.get(0));
                }
            });
            if (jsonArray.size() != ruleList.size()) {
                logger.warn("Sentinel JsonConverter Source list size is not equals to Target List, maybe a part of json is invalid. Source List: " + jsonArray + ", Target List: " + ruleList);
            }
        }
        catch (Exception e) {
            logger.error("Sentinel JsonConverter convert error: " + e.getMessage());
            throw new RuntimeException("Sentinel JsonConverter convert error: " + e.getMessage(), e);
        }
        return ruleList;
    }

    private FlowRule convertFlowRule(String json) {
        try {
            FlowRule rule = (FlowRule)this.objectMapper.readValue(json, FlowRule.class);
            if (FlowRuleUtil.isValidRule((FlowRule)rule)) {
                return rule;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private DegradeRule convertDegradeRule(String json) {
        try {
            DegradeRule rule = (DegradeRule)this.objectMapper.readValue(json, DegradeRule.class);
            if (DegradeRuleManager.isValidRule((DegradeRule)rule)) {
                return rule;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private SystemRule convertSystemRule(String json) {
        SystemRule rule = null;
        try {
            rule = (SystemRule)this.objectMapper.readValue(json, SystemRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }

    private AuthorityRule convertAuthorityRule(String json) {
        AuthorityRule rule = null;
        try {
            rule = (AuthorityRule)this.objectMapper.readValue(json, AuthorityRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }

    private ParamFlowRule convertParamFlowRule(String json) {
        ParamFlowRule rule = null;
        try {
            rule = (ParamFlowRule)this.objectMapper.readValue(json, ParamFlowRule.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }
}

