/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.Ordered;

public class EurekaDiscoveryClient
implements DiscoveryClient {
    public static final String DESCRIPTION = "Spring Cloud Eureka Discovery Client";
    private final EurekaClient eurekaClient;
    private final EurekaClientConfig clientConfig;

    @Deprecated
    public EurekaDiscoveryClient(EurekaInstanceConfig config, EurekaClient eurekaClient) {
        this(eurekaClient, eurekaClient.getEurekaClientConfig());
    }

    public EurekaDiscoveryClient(EurekaClient eurekaClient, EurekaClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.eurekaClient = eurekaClient;
    }

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List infos = this.eurekaClient.getInstancesByVipAddress(serviceId, false);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (InstanceInfo info : infos) {
            instances.add(new EurekaServiceInstance(info));
        }
        return instances;
    }

    public List<String> getServices() {
        Applications applications = this.eurekaClient.getApplications();
        if (applications == null) {
            return Collections.emptyList();
        }
        List registered = applications.getRegisteredApplications();
        ArrayList<String> names = new ArrayList<String>();
        for (Application app : registered) {
            if (app.getInstances().isEmpty()) continue;
            names.add(app.getName().toLowerCase());
        }
        return names;
    }

    public int getOrder() {
        return this.clientConfig instanceof Ordered ? ((Ordered)this.clientConfig).getOrder() : 0;
    }

    @Deprecated
    public static class EurekaServiceInstance
    extends org.springframework.cloud.netflix.eureka.EurekaServiceInstance {
        public EurekaServiceInstance(InstanceInfo instance) {
            super(instance);
        }
    }
}

