/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaHealthCheckHandler;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaAutoServiceRegistration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
public class EurekaDiscoveryClientConfiguration {
    @Deprecated
    @Bean
    public Marker eurekaDiscoverClientMarker() {
        return new Marker();
    }

    @Bean
    @ConditionalOnMissingBean
    public EurekaDiscoveryClient discoveryClient(EurekaClient client, EurekaClientConfig clientConfig) {
        return new EurekaDiscoveryClient(client, clientConfig);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RefreshScopeRefreshedEvent.class})
    protected static class EurekaClientConfigurationRefresher
    implements ApplicationListener<RefreshScopeRefreshedEvent> {
        @Autowired(required=false)
        private EurekaClient eurekaClient;
        @Autowired(required=false)
        private EurekaAutoServiceRegistration autoRegistration;

        protected EurekaClientConfigurationRefresher() {
        }

        public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
            if (this.eurekaClient != null) {
                this.eurekaClient.getApplications();
            }
            if (this.autoRegistration != null) {
                this.autoRegistration.stop();
                this.autoRegistration.start();
            }
        }
    }

    @Deprecated
    class Marker {
        Marker() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"eureka.client.healthcheck.enabled"}, matchIfMissing=false)
    protected static class EurekaHealthCheckHandlerConfiguration {
        @Autowired(required=false)
        private StatusAggregator statusAggregator = new SimpleStatusAggregator();

        protected EurekaHealthCheckHandlerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HealthCheckHandler.class})
        public EurekaHealthCheckHandler eurekaHealthCheckHandler() {
            return new EurekaHealthCheckHandler(this.statusAggregator);
        }
    }
}

