/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.Map;
import org.springframework.cloud.netflix.ribbon.DefaultServerIntrospector;

public class EurekaServerIntrospector
extends DefaultServerIntrospector {
    public boolean isSecure(Server server) {
        if (server instanceof DiscoveryEnabledServer) {
            DiscoveryEnabledServer discoveryServer = (DiscoveryEnabledServer)server;
            return discoveryServer.getInstanceInfo().isPortEnabled(InstanceInfo.PortType.SECURE);
        }
        return super.isSecure(server);
    }

    public Map<String, String> getMetadata(Server server) {
        if (server instanceof DiscoveryEnabledServer) {
            DiscoveryEnabledServer discoveryServer = (DiscoveryEnabledServer)server;
            return discoveryServer.getInstanceInfo().getMetadata();
        }
        return super.getMetadata(server);
    }
}

