/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.zookeeper.KeeperException;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ConfigWatcher
implements Closeable,
TreeCacheListener,
ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(ConfigWatcher.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private List<String> contexts;
    private CuratorFramework source;
    private ApplicationEventPublisher publisher;
    private HashMap<String, TreeCache> caches;

    public ConfigWatcher(List<String> contexts, CuratorFramework source) {
        this.contexts = contexts;
        this.source = source;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostConstruct
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.caches = new HashMap();
            for (String context : this.contexts) {
                if (!context.startsWith("/")) {
                    context = "/" + context;
                }
                try {
                    TreeCache cache = TreeCache.newBuilder((CuratorFramework)this.source, (String)context).build();
                    cache.getListenable().addListener((Object)this);
                    cache.start();
                    this.caches.put(context, cache);
                }
                catch (KeeperException.NoNodeException cache) {
                }
                catch (Exception e) {
                    log.error((Object)("Error initializing listener for context " + context), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            for (TreeCache cache : this.caches.values()) {
                cache.close();
            }
            this.caches = null;
        }
    }

    public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
        TreeCacheEvent.Type eventType = event.getType();
        if (eventType == TreeCacheEvent.Type.NODE_ADDED || eventType == TreeCacheEvent.Type.NODE_REMOVED || eventType == TreeCacheEvent.Type.NODE_UPDATED) {
            this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)event, this.getEventDesc(event)));
        }
    }

    public String getEventDesc(TreeCacheEvent event) {
        StringBuilder out = new StringBuilder();
        out.append("type=").append(event.getType());
        out.append(", path=").append(event.getData().getPath());
        byte[] data = event.getData().getData();
        if (data != null && data.length > 0) {
            out.append(", data=").append(new String(data, Charset.forName("UTF-8")));
        }
        return out.toString();
    }
}

