/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaResultConverters;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public abstract class JpaQueryExecution {
    private static final ConversionService CONVERSION_SERVICE;

    public Object execute(AbstractJpaQuery query, Object[] values) {
        Object result;
        Assert.notNull((Object)query);
        Assert.notNull((Object)values);
        try {
            result = this.doExecute(query, values);
        }
        catch (NoResultException e) {
            return null;
        }
        if (result == null) {
            return null;
        }
        JpaQueryMethod queryMethod = query.getQueryMethod();
        Class<?> requiredType = queryMethod.getReturnType();
        if (Void.TYPE.equals(requiredType) || requiredType.isAssignableFrom(result.getClass())) {
            return result;
        }
        return CONVERSION_SERVICE.canConvert(result.getClass(), requiredType) ? CONVERSION_SERVICE.convert(result, requiredType) : result;
    }

    protected abstract Object doExecute(AbstractJpaQuery var1, Object[] var2);

    static {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter((Converter)JpaResultConverters.BlobToByteArrayConverter.INSTANCE);
        CONVERSION_SERVICE = conversionService;
    }

    static class ProcedureExecution
    extends JpaQueryExecution {
        ProcedureExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery jpaQuery, Object[] values) {
            Assert.isInstanceOf(StoredProcedureJpaQuery.class, (Object)jpaQuery);
            StoredProcedureJpaQuery storedProcedureJpaQuery = (StoredProcedureJpaQuery)jpaQuery;
            StoredProcedureQuery storedProcedure = storedProcedureJpaQuery.createQuery(values);
            storedProcedure.execute();
            return storedProcedureJpaQuery.extractOutputValue(storedProcedure);
        }
    }

    static class DeleteExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public DeleteExecution(EntityManager em) {
            this.em = em;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery jpaQuery, Object[] values) {
            Query query = jpaQuery.createQuery(values);
            List resultList = query.getResultList();
            for (Object o : resultList) {
                this.em.remove(o);
            }
            return jpaQuery.getQueryMethod().isCollectionQuery() ? resultList : Integer.valueOf(resultList.size());
        }
    }

    static class ModifyingExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public ModifyingExecution(JpaQueryMethod method, EntityManager em) {
            Class<?> returnType = method.getReturnType();
            boolean isVoid = Void.TYPE.equals(returnType) || Void.class.equals(returnType);
            boolean isInt = Integer.TYPE.equals(returnType) || Integer.class.equals(returnType);
            Assert.isTrue((isInt || isVoid ? 1 : 0) != 0, (String)"Modifying queries can only use void or int/Integer as return type!");
            this.em = em;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            int result = query.createQuery(values).executeUpdate();
            if (this.em != null) {
                this.em.clear();
            }
            return result;
        }
    }

    static class SingleEntityExecution
    extends JpaQueryExecution {
        SingleEntityExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            return query.createQuery(values).getSingleResult();
        }
    }

    static class PagedExecution
    extends JpaQueryExecution {
        private final Parameters<?, ?> parameters;

        public PagedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery repositoryQuery, Object[] values) {
            TypedQuery<Long> projection = repositoryQuery.createCountQuery(values);
            List totals = projection.getResultList();
            Long total = totals.size() == 1 ? (Long)totals.get(0) : (long)totals.size();
            Query query = repositoryQuery.createQuery(values);
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            Pageable pageable = accessor.getPageable();
            List content = pageable == null || total > (long)pageable.getOffset() ? query.getResultList() : Collections.emptyList();
            return new PageImpl(content, pageable, total.longValue());
        }
    }

    static class SlicedExecution
    extends JpaQueryExecution {
        private final Parameters<?, ?> parameters;

        public SlicedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            Pageable pageable = accessor.getPageable();
            Query createQuery = query.createQuery(values);
            int pageSize = pageable.getPageSize();
            createQuery.setMaxResults(pageSize + 1);
            List resultList = createQuery.getResultList();
            boolean hasNext = resultList.size() > pageSize;
            return new SliceImpl(hasNext ? resultList.subList(0, pageSize) : resultList, pageable, hasNext);
        }
    }

    static class CollectionExecution
    extends JpaQueryExecution {
        CollectionExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, Object[] values) {
            return query.createQuery(values).getResultList();
        }
    }
}

