/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ParameterMetadataProvider {
    private final CriteriaBuilder builder;
    private final Iterator<? extends Parameter> parameters;
    private final List<ParameterMetadata<?>> expressions;
    private Iterator<Object> accessor;

    public ParameterMetadataProvider(CriteriaBuilder builder, ParametersParameterAccessor accessor) {
        this(builder, accessor.getParameters());
        Assert.notNull((Object)accessor);
        this.accessor = accessor.iterator();
    }

    public ParameterMetadataProvider(CriteriaBuilder builder, Parameters<?, ?> parameters) {
        Assert.notNull((Object)builder);
        this.builder = builder;
        this.parameters = parameters.getBindableParameters().iterator();
        this.expressions = new ArrayList();
        this.accessor = null;
    }

    public List<ParameterMetadata<?>> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public <T> ParameterMetadata<T> next(Part part) {
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter.getName());
    }

    public <T> ParameterMetadata<? extends T> next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, null);
    }

    private <T> ParameterMetadata<T> next(Part part, Class<T> type, String name) {
        Assert.notNull(type);
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        ParameterExpression expression = name == null ? this.builder.parameter(reifiedType) : this.builder.parameter(reifiedType, name);
        ParameterMetadata value = new ParameterMetadata(expression, part.getType(), this.accessor == null ? ParameterMetadata.PLACEHOLDER : this.accessor.next());
        this.expressions.add(value);
        return value;
    }

    static class ParameterMetadata<T> {
        static final Object PLACEHOLDER = new Object();
        private final ParameterExpression<T> expression;
        private final Part.Type type;

        public ParameterMetadata(ParameterExpression<T> expression, Part.Type type, Object value) {
            this.expression = expression;
            this.type = value == null && Part.Type.SIMPLE_PROPERTY.equals((Object)type) ? Part.Type.IS_NULL : type;
        }

        public ParameterExpression<T> getExpression() {
            return this.expression;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        public Object prepare(Object parameter) {
            Assert.notNull((Object)parameter);
            switch (this.type) {
                case STARTING_WITH: {
                    return String.format("%s%%", parameter.toString());
                }
                case ENDING_WITH: {
                    return String.format("%%%s", parameter.toString());
                }
                case CONTAINING: {
                    return String.format("%%%s%%", parameter.toString());
                }
            }
            return Collection.class.equals((Object)this.expression.getJavaType()) ? ParameterMetadata.toCollection(parameter) : parameter;
        }

        private static Collection<?> toCollection(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (ObjectUtils.isArray((Object)value)) {
                return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
            }
            return Collections.singleton(value);
        }
    }
}

