/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Comparator;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.PropertyPathComparator;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.lang.Nullable;

public class PathSortAccessor
implements SortAccessor<Comparator<?>> {
    @Override
    @Nullable
    public Comparator<?> resolve(KeyValueQuery<?> query) {
        if (query.getSort().isUnsorted()) {
            return null;
        }
        Optional<Object> comparator = Optional.empty();
        for (Sort.Order order : query.getSort()) {
            PropertyPathComparator pathSort = new PropertyPathComparator(order.getProperty());
            if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                pathSort.desc();
                if (!Sort.NullHandling.NATIVE.equals((Object)order.getNullHandling())) {
                    PropertyPathComparator propertyPathComparator = pathSort = Sort.NullHandling.NULLS_FIRST.equals((Object)order.getNullHandling()) ? pathSort.nullsFirst() : pathSort.nullsLast();
                }
            }
            if (!comparator.isPresent()) {
                comparator = Optional.of(pathSort);
                continue;
            }
            PropertyPathComparator pathSortToUse = pathSort;
            comparator = comparator.map(it -> it.thenComparing(pathSortToUse));
        }
        return (Comparator)comparator.orElseThrow(() -> new IllegalStateException("No sort definitions have been added to this CompoundComparator to compare"));
    }
}

