/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class ExpressionEvaluatingParameterBinder {
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ExpressionQuery expressionQuery;
    private final Map<String, Boolean> namedParameters = new ConcurrentHashMap<String, Boolean>();

    ExpressionEvaluatingParameterBinder(SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider, ExpressionQuery expressionQuery) {
        Assert.notNull((Object)expressionParser, (String)"ExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null");
        Assert.notNull((Object)expressionQuery, (String)"ExpressionQuery must not be null");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.expressionQuery = expressionQuery;
    }

    public <T extends DatabaseClient.BindSpec<T>> T bind(T bindSpec, RelationalParameterAccessor parameterAccessor) {
        Object[] values = parameterAccessor.getValues();
        Parameters bindableParameters = parameterAccessor.getBindableParameters();
        T bindSpecToUse = this.bindExpressions(bindSpec, values, bindableParameters);
        bindSpecToUse = this.bindParameters(bindSpecToUse, parameterAccessor.hasBindableNullValue(), values, bindableParameters);
        return bindSpecToUse;
    }

    private <T extends DatabaseClient.BindSpec<T>> T bindExpressions(T bindSpec, Object[] values, Parameters<?, ?> bindableParameters) {
        T bindSpecToUse = bindSpec;
        for (ExpressionQuery.ParameterBinding binding : this.expressionQuery.getBindings()) {
            SettableValue valueForBinding = this.getParameterValueForBinding(bindableParameters, values, binding);
            if (valueForBinding.isEmpty()) {
                bindSpecToUse = bindSpecToUse.bindNull(binding.getParameterName(), valueForBinding.getType());
                continue;
            }
            bindSpecToUse = bindSpecToUse.bind(binding.getParameterName(), valueForBinding.getValue());
        }
        return bindSpecToUse;
    }

    private <T extends DatabaseClient.BindSpec<T>> T bindParameters(T bindSpec, boolean bindableNull, Object[] values, Parameters<?, ?> bindableParameters) {
        T bindSpecToUse = bindSpec;
        int bindingIndex = 0;
        for (Parameter bindableParameter : bindableParameters) {
            Object value = values[bindableParameter.getIndex()];
            Optional name = bindableParameter.getName();
            if (name.isPresent() && this.isNamedParameterUsed(name) || !this.expressionQuery.getBindings().isEmpty()) {
                if (!this.isNamedParameterUsed(name)) continue;
                if (value == null) {
                    if (!bindableNull) continue;
                    bindSpecToUse = bindSpecToUse.bindNull((String)name.get(), bindableParameter.getType());
                    continue;
                }
                bindSpecToUse = bindSpecToUse.bind((String)name.get(), value);
                continue;
            }
            if (value == null) {
                if (!bindableNull) continue;
                bindSpecToUse = bindSpecToUse.bindNull(bindingIndex++, bindableParameter.getType());
                continue;
            }
            bindSpecToUse = bindSpecToUse.bind(bindingIndex++, value);
        }
        return bindSpecToUse;
    }

    private boolean isNamedParameterUsed(Optional<String> name) {
        if (!name.isPresent()) {
            return false;
        }
        return this.namedParameters.computeIfAbsent(name.get(), it -> {
            Pattern namedParameterPattern = Pattern.compile("(\\W)[:#$@]" + Pattern.quote(it) + "(\\W|$)");
            return namedParameterPattern.matcher(this.expressionQuery.getQuery()).find();
        });
    }

    private SettableValue getParameterValueForBinding(Parameters<?, ?> parameters, Object[] values, ExpressionQuery.ParameterBinding binding) {
        return this.evaluateExpression(binding.getExpression(), parameters, values);
    }

    private SettableValue evaluateExpression(String expressionString, Parameters<?, ?> parameters, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(parameters, parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        Object value = expression.getValue(evaluationContext, Object.class);
        Class<Object> valueType = expression.getValueType(evaluationContext);
        return SettableValue.fromOrEmpty(value, valueType != null ? valueType : Object.class);
    }
}

