/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.enhancement.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.springframework.config.java.core.EnhancerMethodInvoker;
import org.springframework.config.java.core.StandardBeanMethodProcessor;
import org.springframework.util.Assert;

class BeanMethodMethodInterceptor
implements MethodInterceptor {
    private final StandardBeanMethodProcessor beanMethodProcessor;

    public BeanMethodMethodInterceptor(StandardBeanMethodProcessor beanMethodProcessor) {
        Assert.notNull((Object)beanMethodProcessor);
        this.beanMethodProcessor = beanMethodProcessor;
    }

    public Object intercept(Object o, Method m, Object[] args, MethodProxy mp) throws Throwable {
        return this.returnWrappedResultMayBeCached(this.beanMethodProcessor.getBeanName(m), o, m, args, mp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object returnWrappedResultMayBeCached(String beanName, final Object o, final Method m, final Object[] args, final MethodProxy mp) throws Throwable {
        Object object = o;
        synchronized (object) {
            return this.beanMethodProcessor.createNewOrGetCachedSingletonBean(beanName, new EnhancerMethodInvoker(){

                public Method getMethod() {
                    return m;
                }

                public Object invokeOriginalClass() throws Throwable {
                    return mp.invokeSuper(o, args);
                }
            });
        }
    }
}

