/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Field;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public class DependencyDescriptor {
    private MethodParameter methodParameter;
    private Field field;
    private final boolean required;

    public DependencyDescriptor(MethodParameter methodParameter, boolean required) {
        Assert.notNull((Object)methodParameter, (String)"MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.required = required;
    }

    public DependencyDescriptor(Field field, boolean required) {
        Assert.notNull((Object)field, (String)"Field must not be null");
        this.field = field;
        this.required = required;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class getDependencyType() {
        return this.field != null ? this.field.getType() : this.methodParameter.getParameterType();
    }

    public Class getCollectionType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getCollectionFieldType((Field)this.field) : GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)this.methodParameter);
    }

    public Class getMapKeyType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getMapKeyFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)this.methodParameter);
    }

    public Class getMapValueType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getMapValueFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)this.methodParameter);
    }

    public Object[] getAnnotations() {
        if (this.field != null) {
            if (JdkVersion.getMajorJavaVersion() < 2) {
                return null;
            }
            return this.field.getAnnotations();
        }
        return this.methodParameter.getParameterAnnotations();
    }
}

