/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Map;
import java.util.Set;
import javax.portlet.PortalContext;
import javax.portlet.PortletResponse;
import org.springframework.core.CollectionFactory;
import org.springframework.mock.web.portlet.MockPortalContext;
import org.springframework.util.Assert;

public class MockPortletResponse
implements PortletResponse {
    private final PortalContext portalContext;
    private final Map properties = CollectionFactory.createLinkedMapIfPossible((int)16);

    public MockPortletResponse(PortalContext portalContext) {
        Assert.notNull((Object)portalContext, (String)"PortalContext is required");
        this.portalContext = portalContext;
    }

    public MockPortletResponse() {
        this.portalContext = new MockPortalContext();
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public void addProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        String[] oldArr = (String[])this.properties.get(key);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + 1];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            newArr[oldArr.length] = value;
            this.properties.put(key, newArr);
        } else {
            this.properties.put(key, new String[]{value});
        }
    }

    public void setProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        this.properties.put(key, new String[]{value});
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }

    public String getProperty(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        String[] arr = (String[])this.properties.get(key);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getProperties(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        return (String[])this.properties.get(key);
    }

    public String encodeURL(String path) {
        return path;
    }
}

