/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jpa;

import java.util.LinkedList;
import java.util.List;
import org.springframework.instrument.classloading.ResourceOverridingShadowingClassLoader;

class OrmXmlOverridingShadowingClassLoader
extends ResourceOverridingShadowingClassLoader {
    private List<String> providerPrefixes = new LinkedList<String>();

    public OrmXmlOverridingShadowingClassLoader(ClassLoader loader, String realOrmXmlLocation) {
        super(loader);
        this.providerPrefixes.add("oracle.toplink.essentials");
        this.override("META-INF/orm.xml", realOrmXmlLocation);
    }

    protected boolean isClassNameExcludedFromShadowing(String className) {
        for (String providerPrefix : this.providerPrefixes) {
            if (!className.startsWith(providerPrefix)) continue;
            return true;
        }
        return className.startsWith("junit");
    }
}

