/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockJspWriter;

public class MockBodyContent
extends BodyContent {
    private final String content;

    public MockBodyContent(String content, HttpServletResponse response) {
        this(content, response, null);
    }

    public MockBodyContent(String content, Writer targetWriter) {
        this(content, null, targetWriter);
    }

    public MockBodyContent(String content, @Nullable HttpServletResponse response, @Nullable Writer targetWriter) {
        super(MockBodyContent.adaptJspWriter(targetWriter, response));
        this.content = content;
    }

    private static JspWriter adaptJspWriter(@Nullable Writer targetWriter, @Nullable HttpServletResponse response) {
        if (targetWriter instanceof JspWriter) {
            return (JspWriter)targetWriter;
        }
        return new MockJspWriter(response, targetWriter);
    }

    public Reader getReader() {
        return new StringReader(this.content);
    }

    public String getString() {
        return this.content;
    }

    public void writeOut(Writer writer) throws IOException {
        writer.write(this.content);
    }

    public void clear() throws IOException {
        this.getEnclosingWriter().clear();
    }

    public void clearBuffer() throws IOException {
        this.getEnclosingWriter().clearBuffer();
    }

    public void close() throws IOException {
        this.getEnclosingWriter().close();
    }

    public int getRemaining() {
        return this.getEnclosingWriter().getRemaining();
    }

    public void newLine() throws IOException {
        this.getEnclosingWriter().println();
    }

    public void write(char[] value, int offset, int length) throws IOException {
        this.getEnclosingWriter().write(value, offset, length);
    }

    public void print(boolean value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(char value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(char[] value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(double value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(float value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(int value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(long value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(Object value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void print(String value) throws IOException {
        this.getEnclosingWriter().print(value);
    }

    public void println() throws IOException {
        this.getEnclosingWriter().println();
    }

    public void println(boolean value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(char value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(char[] value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(double value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(float value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(int value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(long value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(Object value) throws IOException {
        this.getEnclosingWriter().println(value);
    }

    public void println(String value) throws IOException {
        this.getEnclosingWriter().println(value);
    }
}

