/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.context.MethodInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

final class DefaultMethodInvoker
implements MethodInvoker {
    private static final Log logger = LogFactory.getLog(DefaultMethodInvoker.class);

    DefaultMethodInvoker() {
    }

    @Override
    @Nullable
    public Object invoke(Method method, @Nullable Object target) throws Exception {
        Assert.notNull((Object)method, (String)"Method must not be null");
        try {
            ReflectionUtils.makeAccessible((Method)method);
            return method.invoke(target, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Exception encountered while invoking method [%s] on target [%s]".formatted(method, target), ex.getTargetException());
            }
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            return null;
        }
    }
}

