/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.client.DefaultRestTestClient;
import org.springframework.test.web.servlet.client.EntityExchangeResult;
import org.springframework.test.web.servlet.client.MockMvcClientHttpRequestFactory;
import org.springframework.test.web.servlet.client.RestTestClient;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.RouterFunctionMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.client.RestClient;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.util.UriBuilderFactory;

class DefaultRestTestClientBuilder<B extends RestTestClient.Builder<B>>
implements RestTestClient.Builder<B> {
    private final RestClient.Builder restClientBuilder;
    private Consumer<EntityExchangeResult<?>> entityResultConsumer;

    DefaultRestTestClientBuilder() {
        this(RestClient.builder());
    }

    DefaultRestTestClientBuilder(RestClient.Builder restClientBuilder) {
        this.entityResultConsumer = result -> {};
        this.restClientBuilder = restClientBuilder;
    }

    DefaultRestTestClientBuilder(DefaultRestTestClientBuilder<B> other) {
        this.entityResultConsumer = result -> {};
        this.restClientBuilder = other.restClientBuilder.clone();
        this.entityResultConsumer = other.entityResultConsumer;
    }

    @Override
    public <T extends B> T baseUrl(String baseUrl) {
        this.restClientBuilder.baseUrl(baseUrl);
        return this.self();
    }

    @Override
    public <T extends B> T uriBuilderFactory(UriBuilderFactory uriFactory) {
        this.restClientBuilder.uriBuilderFactory(uriFactory);
        return this.self();
    }

    @Override
    public <T extends B> T defaultHeader(String headerName, String ... headerValues) {
        this.restClientBuilder.defaultHeader(headerName, headerValues);
        return this.self();
    }

    @Override
    public <T extends B> T defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        this.restClientBuilder.defaultHeaders(headersConsumer);
        return this.self();
    }

    @Override
    public <T extends B> T defaultCookie(String cookieName, String ... cookieValues) {
        this.restClientBuilder.defaultCookie(cookieName, cookieValues);
        return this.self();
    }

    @Override
    public <T extends B> T defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        this.restClientBuilder.defaultCookies(cookiesConsumer);
        return this.self();
    }

    @Override
    public <T extends B> T defaultApiVersion(Object version) {
        this.restClientBuilder.defaultApiVersion(version);
        return this.self();
    }

    @Override
    public <T extends B> T apiVersionInserter(ApiVersionInserter apiVersionInserter) {
        this.restClientBuilder.apiVersionInserter(apiVersionInserter);
        return this.self();
    }

    @Override
    public <T extends B> T requestInterceptor(ClientHttpRequestInterceptor interceptor) {
        this.restClientBuilder.requestInterceptor(interceptor);
        return this.self();
    }

    @Override
    public <T extends B> T requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> interceptorsConsumer) {
        this.restClientBuilder.requestInterceptors(interceptorsConsumer);
        return this.self();
    }

    @Override
    public <T extends B> T configureMessageConverters(Consumer<HttpMessageConverters.ClientBuilder> configurer) {
        this.restClientBuilder.configureMessageConverters(configurer);
        return this.self();
    }

    @Override
    public <T extends B> T entityExchangeResultConsumer(Consumer<EntityExchangeResult<?>> entityResultConsumer) {
        Assert.notNull(entityResultConsumer, (String)"'entityResultConsumer' is required");
        this.entityResultConsumer = this.entityResultConsumer.andThen(entityResultConsumer);
        return this.self();
    }

    protected <T extends B> T self() {
        return (T)this;
    }

    protected void setClientHttpRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restClientBuilder.requestFactory(requestFactory);
    }

    @Override
    public RestTestClient build() {
        return new DefaultRestTestClient(this.restClientBuilder, this.entityResultConsumer, new DefaultRestTestClientBuilder<B>(this));
    }

    static class DefaultWebAppContextSetupBuilder
    extends AbstractMockMvcSetupBuilder<RestTestClient.WebAppContextSetupBuilder, DefaultMockMvcBuilder>
    implements RestTestClient.WebAppContextSetupBuilder {
        DefaultWebAppContextSetupBuilder(WebApplicationContext context) {
            super(MockMvcBuilders.webAppContextSetup(context));
        }
    }

    static class DefaultRouterFunctionSetupBuilder
    extends AbstractMockMvcSetupBuilder<RestTestClient.RouterFunctionSetupBuilder, RouterFunctionMockMvcBuilder>
    implements RestTestClient.RouterFunctionSetupBuilder {
        DefaultRouterFunctionSetupBuilder(RouterFunction<?> ... routerFunctions) {
            super(MockMvcBuilders.routerFunctions(routerFunctions));
        }
    }

    static class DefaultStandaloneSetupBuilder
    extends AbstractMockMvcSetupBuilder<RestTestClient.StandaloneSetupBuilder, StandaloneMockMvcBuilder>
    implements RestTestClient.StandaloneSetupBuilder {
        DefaultStandaloneSetupBuilder(Object ... controllers) {
            super(MockMvcBuilders.standaloneSetup(controllers));
        }
    }

    static class AbstractMockMvcSetupBuilder<S extends RestTestClient.Builder<S>, M extends MockMvcBuilder>
    extends DefaultRestTestClientBuilder<S>
    implements RestTestClient.MockMvcSetupBuilder<S, M> {
        private final M mockMvcBuilder;

        public AbstractMockMvcSetupBuilder(M mockMvcBuilder) {
            this.mockMvcBuilder = mockMvcBuilder;
        }

        @Override
        public <T extends S> T configureServer(Consumer<M> consumer) {
            consumer.accept(this.mockMvcBuilder);
            return this.self();
        }

        @Override
        public RestTestClient build() {
            MockMvc mockMvc = this.mockMvcBuilder.build();
            this.setClientHttpRequestFactory(new MockMvcClientHttpRequestFactory(mockMvc));
            return super.build();
        }
    }
}

