/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server.assertj;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;
import org.springframework.http.ResponseCookie;

public class ResponseCookieMapAssert
extends AbstractMapAssert<ResponseCookieMapAssert, Map<String, ResponseCookie>, String, ResponseCookie> {
    public ResponseCookieMapAssert(ResponseCookie[] actual) {
        super(ResponseCookieMapAssert.toMap(actual), ResponseCookieMapAssert.class);
        this.as("Cookies", new Object[0]);
    }

    private static Map<String, ResponseCookie> toMap(ResponseCookie[] cookies) {
        LinkedHashMap<String, ResponseCookie> map = new LinkedHashMap<String, ResponseCookie>();
        for (ResponseCookie cookie : cookies) {
            map.putIfAbsent(cookie.getName(), cookie);
        }
        return map;
    }

    public ResponseCookieMapAssert containsCookie(String name) {
        return (ResponseCookieMapAssert)this.containsKey(name);
    }

    public ResponseCookieMapAssert containsCookies(String ... names) {
        return (ResponseCookieMapAssert)this.containsKeys(names);
    }

    public ResponseCookieMapAssert doesNotContainCookie(String name) {
        return (ResponseCookieMapAssert)this.doesNotContainKey(name);
    }

    public ResponseCookieMapAssert doesNotContainCookies(String ... names) {
        return (ResponseCookieMapAssert)this.doesNotContainKeys(names);
    }

    public ResponseCookieMapAssert hasCookieSatisfying(String name, Consumer<ResponseCookie> cookieRequirements) {
        return (ResponseCookieMapAssert)this.hasEntrySatisfying(name, cookieRequirements);
    }

    public ResponseCookieMapAssert hasValue(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getValue()).isEqualTo(expected));
    }

    public ResponseCookieMapAssert hasMaxAge(String name, Duration expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((Duration)cookie.getMaxAge()).isEqualTo((Object)expected));
    }

    public ResponseCookieMapAssert hasPath(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getPath()).isEqualTo(expected));
    }

    public ResponseCookieMapAssert hasDomain(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getDomain()).isEqualTo(expected));
    }

    public ResponseCookieMapAssert isSecure(String name, boolean expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((boolean)cookie.isSecure()).isEqualTo(expected));
    }

    public ResponseCookieMapAssert isHttpOnly(String name, boolean expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((boolean)cookie.isHttpOnly()).isEqualTo(expected));
    }
}

