/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

class DefaultServerEndpointConfig
extends ServerEndpointConfig.Configurator
implements ServerEndpointConfig {
    private final String path;
    private final Endpoint endpoint;
    private List<String> protocols = new ArrayList<String>();

    public DefaultServerEndpointConfig(String path, Endpoint endpoint) {
        Assert.hasText((String)path, (String)"path must not be empty");
        Assert.notNull((Object)endpoint, (String)"endpoint must not be null");
        this.path = path;
        this.endpoint = endpoint;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return new ArrayList<Class<? extends Encoder>>();
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return new ArrayList<Class<? extends Decoder>>();
    }

    public Map<String, Object> getUserProperties() {
        return new HashMap<String, Object>();
    }

    public Class<?> getEndpointClass() {
        return this.endpoint.getClass();
    }

    public String getPath() {
        return this.path;
    }

    public void setSubprotocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public List<String> getSubprotocols() {
        return this.protocols;
    }

    public List<Extension> getExtensions() {
        return new ArrayList<Extension>();
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        return this;
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        return (T)this.endpoint;
    }

    public String toString() {
        return "DefaultServerEndpointConfig for path '" + this.getPath() + "': " + String.valueOf(this.getEndpointClass());
    }
}

