/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.ArrayUtil;
import org.tio.utils.hutool.BeanInfoCache;
import org.tio.utils.hutool.CaseInsensitiveMap;
import org.tio.utils.hutool.Filter;

public class BeanUtil {
    private static Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), new Filter<PropertyDescriptor>(){

            @Override
            public boolean accept(PropertyDescriptor t) {
                return false == "class".equals(t.getName());
            }
        });
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws IntrospectionException {
        Map<String, PropertyDescriptor> map = BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase);
        if (null == map) {
            map = BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase);
            BeanInfoCache.INSTANCE.putPropertyDescriptorMap(clazz, map, ignoreCase);
        }
        return map;
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws IntrospectionException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws IntrospectionException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }
}

