/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.tio.utils.hutool.Validator;

public class DateUtil {
    private static Date toDate(String dateStr, String patternStr) {
        Date date;
        SimpleDateFormat fmt = new SimpleDateFormat(patternStr);
        try {
            date = fmt.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    public static String guessPattern(String dateStr) {
        dateStr = dateStr.trim().replace("\u65e5", "");
        int length = dateStr.length();
        if (Validator.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return "yyyyMMddHHmmss";
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return "yyyyMMddHHmmssSSS";
            }
            if (length == "yyyyMMdd".length()) {
                return "yyyyMMdd";
            }
            if (length == "HHmmss".length()) {
                return "HHmmss";
            }
        }
        if (length == "yyyy-MM-dd HH:mm:ss".length() || length == "yyyy-MM-dd HH:mm:ss".length() + 1) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        if (length == "yyyy-MM-dd".length()) {
            return "yyyy-MM-dd";
        }
        if (length == "HH:mm:ss".length() || length == "HH:mm:ss".length() + 1) {
            return "HH:mm:ss";
        }
        if (length == "yyyy-MM-dd HH:mm".length() || length == "yyyy-MM-dd HH:mm".length() + 1) {
            return "yyyy-MM-dd HH:mm";
        }
        if (length >= "yyyy-MM-dd HH:mm:ss.SSS".length() - 2) {
            return "yyyy-MM-dd HH:mm:ss.SSS";
        }
        return null;
    }

    public static Date parseToDate(String dateStr) {
        String p = DateUtil.guessPattern(dateStr);
        if (p == null) {
            return null;
        }
        return DateUtil.toDate(dateStr, p);
    }

    public static java.sql.Date parseToSqlDate(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new java.sql.Date(d.getTime());
    }

    public static Timestamp parseToTimestamp(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    public static Time parseToTime(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new Time(d.getTime());
    }

    public static String httpDate() {
        return DateUtil.httpDate(new Date());
    }

    public static String httpDate(Date date) {
        SimpleDateFormat greenwichDate = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        return greenwichDate.format(date);
    }

    public static String httpDate(long millis) {
        return DateUtil.httpDate(new Date(millis));
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static int daysBetween(Date date1, Date date2) {
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long iv = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(iv));
    }
}

