/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.tio.utils.hutool.StrUtil;

public class ResourceUtil {
    private static String CLASSPATH_PRE = "classpath:";

    public static String getAbsolutePath(String path) {
        return ResourceUtil.getDecodedPath(ResourceUtil.getResource(path));
    }

    public static URL getResource(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResourceAsStream(path);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && null == (classLoader = ResourceUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }
}

