/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.concurrent.Future;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class OracleContainer
extends JdbcDatabaseContainer<OracleContainer> {
    public static final String NAME = "oracle";
    private static final int ORACLE_PORT = 1521;
    private static final int APEX_HTTP_PORT = 8080;
    private static final int DEFAULT_STARTUP_TIMEOUT_SECONDS = 240;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 120;
    private String username = "system";
    private String password = "oracle";

    private static String resolveImageName() {
        String image = TestcontainersConfiguration.getInstance().getProperties().getProperty("oracle.container.image");
        if (image == null) {
            throw new IllegalStateException("An image to use for Oracle containers must be configured. To do this, please place a file on the classpath named `testcontainers.properties`, containing `oracle.container.image=IMAGE`, where IMAGE is a suitable image name and tag.");
        }
        return image;
    }

    public OracleContainer() {
        this(OracleContainer.resolveImageName());
    }

    public OracleContainer(String dockerImageName) {
        super(dockerImageName);
        this.preconfigure();
    }

    public OracleContainer(Future<String> dockerImageName) {
        super(dockerImageName);
        this.preconfigure();
    }

    private void preconfigure() {
        this.withStartupTimeoutSeconds(240);
        this.withConnectTimeoutSeconds(120);
        this.addExposedPorts(new int[]{1521, 8080});
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(1521);
    }

    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:oracle:thin:" + this.getUsername() + "/" + this.getPassword() + "@" + this.getHost() + ":" + this.getOraclePort() + ":" + this.getSid();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public OracleContainer withUsername(String username) {
        this.username = username;
        return (OracleContainer)this.self();
    }

    public OracleContainer withPassword(String password) {
        this.password = password;
        return (OracleContainer)this.self();
    }

    public OracleContainer withUrlParam(String paramName, String paramValue) {
        throw new UnsupportedOperationException("The OracleDb does not support this");
    }

    public String getSid() {
        return "xe";
    }

    public Integer getOraclePort() {
        return this.getMappedPort(1521);
    }

    public Integer getWebPort() {
        return this.getMappedPort(8080);
    }

    public String getTestQueryString() {
        return "SELECT 1 FROM DUAL";
    }
}

