/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public final class Interval
implements Serializable {
    private static final long serialVersionUID = 8375285238652L;
    private final Instant start;
    private final Instant end;

    public static Interval of(Instant startInclusive, Instant endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        if (endExclusive.isBefore(startInclusive)) {
            throw new DateTimeException("Start instant must be before end instant");
        }
        return new Interval(startInclusive, endExclusive);
    }

    public static Interval of(Instant startInclusive, Duration duration) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(duration, "duration");
        if (duration.isNegative()) {
            throw new DateTimeException("Duration must not be zero or negative");
        }
        return new Interval(startInclusive, startInclusive.plus(duration));
    }

    public static Interval parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '/') continue;
            Instant start = Instant.parse(text.subSequence(0, i));
            Instant end = Instant.parse(text.subSequence(i + 1, text.length()));
            return Interval.of(start, end);
        }
        throw new DateTimeParseException("Interval cannot be parsed, no forward slash found", text, 0);
    }

    private Interval(Instant startInclusive, Instant endExclusive) {
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Interval withStart(Instant start) {
        return Interval.of(start, this.end);
    }

    public Interval withEnd(Instant end) {
        return Interval.of(this.start, end);
    }

    public boolean contains(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return instant.compareTo(this.start) >= 0 && instant.compareTo(this.end) < 0;
    }

    public boolean encloses(Interval interval) {
        Objects.requireNonNull(interval, "interval");
        return this.start.compareTo(interval.start) <= 0 && interval.end.compareTo(this.end) <= 0;
    }

    public boolean overlaps(Interval interval) {
        Objects.requireNonNull(interval, "interval");
        return interval.equals(this) || this.start.compareTo(interval.end) < 0 && interval.start.compareTo(this.end) < 0;
    }

    public boolean abuts(Interval interval) {
        Objects.requireNonNull(interval, "interval");
        return this.end.equals(interval.start) ^ this.start.equals(interval.end);
    }

    public Duration toDuration() {
        return Duration.between(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Interval) {
            Interval other = (Interval)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + '/' + this.end.toString();
    }
}

