/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.ClazzpathUnit;
import org.vafer.jdependency.asm.DependenciesClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Clazzpath {
    private final Set<ClazzpathUnit> units = new HashSet<ClazzpathUnit>();
    private final Map<String, Clazz> missing = new HashMap<String, Clazz>();
    private final Map<String, Clazz> clazzes = new HashMap<String, Clazz>();

    public boolean removeClazzpathUnit(ClazzpathUnit pUnit) {
        Set<Clazz> unitClazzes = pUnit.getClazzes();
        for (Clazz clazz : unitClazzes) {
            clazz.removeClazzpathUnit(pUnit);
            if (clazz.getClazzpathUnits().size() != 0) continue;
            this.clazzes.remove(clazz.toString());
        }
        return this.units.remove(pUnit);
    }

    public final ClazzpathUnit addClazzpathUnit(File pFile) throws IOException {
        return this.addClazzpathUnit(pFile, pFile.getAbsolutePath());
    }

    public ClazzpathUnit addClazzpathUnit(File pFile, String pId) throws IOException {
        if (pFile.isFile()) {
            return this.addClazzpathUnit(new FileInputStream(pFile), pId);
        }
        if (pFile.isDirectory()) {
            final String prefix = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)(pFile.getAbsolutePath() + File.separatorChar)));
            boolean recursive = true;
            final Iterator files = FileUtils.iterateFiles((File)pFile, (String[])new String[]{"class"}, (boolean)true);
            return this.addClazzpathUnit(new Iterable<Resource>(){

                @Override
                public Iterator<Resource> iterator() {
                    return new Iterator<Resource>(){

                        @Override
                        public boolean hasNext() {
                            return files.hasNext();
                        }

                        @Override
                        public Resource next() {
                            final File file = (File)files.next();
                            return new Resource(file.getAbsolutePath().substring(prefix.length())){

                                InputStream getInputStream() throws IOException {
                                    return new FileInputStream(file);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }, pId, true);
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClazzpathUnit addClazzpathUnit(InputStream pInputStream, String pId) throws IOException {
        final JarInputStream inputStream = new JarInputStream(pInputStream);
        try {
            final JarEntry[] entryHolder = new JarEntry[1];
            ClazzpathUnit clazzpathUnit = this.addClazzpathUnit(new Iterable<Resource>(){

                @Override
                public Iterator<Resource> iterator() {
                    return new Iterator<Resource>(){

                        @Override
                        public boolean hasNext() {
                            try {
                                do {
                                    entryHolder[0] = inputStream.getNextJarEntry();
                                } while (entryHolder[0] != null && !Resource.isValidName(entryHolder[0].getName()));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            return entryHolder[0] != null;
                        }

                        @Override
                        public Resource next() {
                            return new Resource(entryHolder[0].getName()){

                                InputStream getInputStream() {
                                    return inputStream;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }, pId, false);
            return clazzpathUnit;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClazzpathUnit addClazzpathUnit(Iterable<Resource> resources, String pId, boolean shouldCloseResourceStream) throws IOException {
        HashMap<String, Clazz> unitClazzes = new HashMap<String, Clazz>();
        HashMap<String, Clazz> unitDependencies = new HashMap<String, Clazz>();
        ClazzpathUnit unit = new ClazzpathUnit(pId, unitClazzes, unitDependencies);
        for (Resource resource : resources) {
            String clazzName = resource.name;
            Clazz clazz = this.getClazz(clazzName);
            if (clazz == null) {
                clazz = this.missing.get(clazzName);
                clazz = clazz != null ? this.missing.remove(clazzName) : new Clazz(clazzName);
            }
            clazz.addClazzpathUnit(unit);
            this.clazzes.put(clazzName, clazz);
            unitClazzes.put(clazzName, clazz);
            DependenciesClassAdapter v = new DependenciesClassAdapter();
            InputStream inputStream = resource.getInputStream();
            try {
                new ClassReader(inputStream).accept((ClassVisitor)v, 10);
            }
            finally {
                if (shouldCloseResourceStream) {
                    inputStream.close();
                }
            }
            Set<String> depNames = v.getDependencies();
            for (String depName : depNames) {
                Clazz dep = this.getClazz(depName);
                if (dep == null) {
                    dep = this.missing.get(depName);
                }
                if (dep == null) {
                    dep = new Clazz(depName);
                    dep.addClazzpathUnit(unit);
                    this.missing.put(depName, dep);
                }
                if (dep == clazz) continue;
                unitDependencies.put(depName, dep);
                clazz.addDependency(dep);
            }
        }
        this.units.add(unit);
        return unit;
    }

    public Set<Clazz> getClazzes() {
        HashSet<Clazz> result = new HashSet<Clazz>(this.clazzes.values());
        return result;
    }

    public Set<Clazz> getClashedClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            if (clazz.getClazzpathUnits().size() <= 1) continue;
            all.add(clazz);
        }
        return all;
    }

    public Set<Clazz> getMissingClazzes() {
        HashSet<Clazz> result = new HashSet<Clazz>(this.missing.values());
        return result;
    }

    public Clazz getClazz(String pClazzName) {
        Clazz result = this.clazzes.get(pClazzName);
        return result;
    }

    public ClazzpathUnit[] getUnits() {
        ClazzpathUnit[] result = this.units.toArray(new ClazzpathUnit[this.units.size()]);
        return result;
    }

    private static abstract class Resource {
        final String name;

        Resource(String pName) {
            this.name = pName.substring(0, pName.length() - 6).replace('/', '.');
        }

        abstract InputStream getInputStream() throws IOException;

        static boolean isValidName(String pName) {
            return pName != null && pName.endsWith(".class") && !pName.contains("-");
        }
    }
}

