/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.markedcontent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosLang;
import org.verapdf.gf.model.impl.cos.GFCosName;
import org.verapdf.gf.model.impl.operator.base.GFOperator;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.operator.OpMarkedContent;
import org.verapdf.pd.PDResource;

public abstract class GFOpMarkedContent
extends GFOperator
implements OpMarkedContent {
    public static final String TAG = "tag";
    public static final String PROPERTIES = "properties";
    public static final String LANG = "Lang";
    private COSDictionary propertiesDict;

    public GFOpMarkedContent(List<COSBase> arguments, String opType, PDResourcesHandler resources) {
        super(arguments, opType);
        this.initializePropertiesDict(resources);
    }

    private void initializePropertiesDict(PDResourcesHandler resources) {
        if (!this.arguments.isEmpty()) {
            COSBase cosProperties;
            PDResource properties;
            COSBase lastArg = (COSBase)this.arguments.get(this.arguments.size() - 1);
            COSObjType lastArgType = lastArg.getType();
            if (lastArgType == COSObjType.COS_DICT) {
                this.propertiesDict = (COSDictionary)lastArg;
            } else if (lastArgType == COSObjType.COS_NAME && resources != null && (properties = resources.getProperties(lastArg.getName())) != null && (cosProperties = properties.getObject().getDirectBase()) != null && cosProperties.getType() == COSObjType.COS_DICT) {
                this.propertiesDict = (COSDictionary)cosProperties;
            }
        }
    }

    protected List<CosName> getTag() {
        COSBase name;
        if (this.arguments.size() > 1 && (name = (COSBase)this.arguments.get(this.arguments.size() - 2)).getType() == COSObjType.COS_NAME) {
            ArrayList<GFCosName> list = new ArrayList<GFCosName>(1);
            list.add(new GFCosName((COSName)name));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected List<CosDict> getPropertiesDict() {
        if (this.propertiesDict != null) {
            ArrayList<GFCosDict> list = new ArrayList<GFCosDict>(1);
            list.add(new GFCosDict(this.propertiesDict));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    protected List<CosLang> getLang() {
        COSObject lang = this.getAttribute(ASAtom.LANG, COSObjType.COS_STRING);
        if (lang != null) {
            ArrayList<GFCosLang> list = new ArrayList<GFCosLang>(1);
            list.add(new GFCosLang((COSString)lang.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public COSString getActualText() {
        COSObject actualText = this.getAttribute(ASAtom.ACTUAL_TEXT, COSObjType.COS_STRING);
        return actualText == null ? null : (COSString)actualText.get();
    }

    public Long getMCID() {
        COSObject mcid = this.getAttribute(ASAtom.MCID, COSObjType.COS_INTEGER);
        return mcid == null ? null : mcid.getInteger();
    }

    private COSObject getAttribute(ASAtom attributeName, COSObjType expectedType) {
        COSObject res;
        if (this.propertiesDict != null && (res = this.propertiesDict.getKey(attributeName)) != null && !res.empty() && res.getType() == expectedType) {
            return res;
        }
        return null;
    }

    public int hashCode() {
        return this.propertiesDict == null ? 0 : this.propertiesDict.hashCode();
    }
}

