/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.controller;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.spi.event.container.ContainerEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.controller.StopContainerWithTimeout;

public class WildFlyContainerLifecycleController {
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Event<ContainerEvent> event;

    public void stopContainerWithTimeout(final @Observes StopContainerWithTimeout stopEvent) throws Exception {
        this.forContainer(stopEvent.getContainer(), new Operation<Container>(){

            @Override
            public void perform(Container container) throws Exception {
                WildFlyContainerLifecycleController.this.event.fire((Object)new BeforeStop(container.getDeployableContainer()));
                try {
                    if (container.getState().equals((Object)Container.State.STARTED)) {
                        CommonDeployableContainer c = (CommonDeployableContainer)container.getDeployableContainer();
                        c.stop(stopEvent.getTimeout());
                    }
                    container.setState(Container.State.STOPPED);
                }
                catch (LifecycleException e) {
                    container.setState(Container.State.STOPPED_FAILED);
                    throw e;
                }
                WildFlyContainerLifecycleController.this.event.fire((Object)new AfterStop(container.getDeployableContainer()));
            }
        });
    }

    private void forContainer(Container container, Operation<Container> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        operation.perform(container);
    }

    public static interface Operation<T> {
        public void perform(T var1) throws Exception;
    }
}

