/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.logbook.Origin;

@API(status=API.Status.STABLE)
public interface BaseHttpMessage {
    public String getProtocolVersion();

    public Origin getOrigin();

    public Map<String, List<String>> getHeaders();

    @Nullable
    public String getContentType();

    public Charset getCharset();

    public static class HeadersBuilder {
        private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

        public HeadersBuilder put(String key, String value) {
            List<String> values = this.headers.get(key);
            if (values != null) {
                values.add(value);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(value);
                this.headers.put(key, list);
            }
            return this;
        }

        public HeadersBuilder put(String key, Iterable<String> values) {
            for (String value : values) {
                this.put(key, value);
            }
            return this;
        }

        public Map<String, List<String>> build() {
            for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
                e.setValue(Collections.unmodifiableList(e.getValue()));
            }
            this.headers = Collections.unmodifiableMap(this.headers);
            return this.headers;
        }
    }
}

