/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.JGitProvider;
import pl.project13.maven.git.NativeGitProvider;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;
import pl.project13.maven.git.util.PropertyManager;

public class GitCommitIdMojo
extends AbstractMojo {
    public static final String BRANCH = "branch";
    public static final String COMMIT_ID = "commit.id";
    public static final String COMMIT_ID_ABBREV = "commit.id.abbrev";
    public static final String COMMIT_DESCRIBE = "commit.id.describe";
    public static final String COMMIT_SHORT_DESCRIBE = "commit.id.describe-short";
    public static final String BUILD_AUTHOR_NAME = "build.user.name";
    public static final String BUILD_AUTHOR_EMAIL = "build.user.email";
    public static final String BUILD_TIME = "build.time";
    public static final String COMMIT_AUTHOR_NAME = "commit.user.name";
    public static final String COMMIT_AUTHOR_EMAIL = "commit.user.email";
    public static final String COMMIT_MESSAGE_FULL = "commit.message.full";
    public static final String COMMIT_MESSAGE_SHORT = "commit.message.short";
    public static final String COMMIT_TIME = "commit.time";
    public static final String REMOTE_ORIGIN_URL = "remote.origin.url";
    public static final String TAGS = "tags";
    MavenProject project;
    private List<MavenProject> reactorProjects;
    private boolean injectAllReactorProjects;
    private boolean verbose;
    private boolean skipPoms;
    private boolean generateGitPropertiesFile;
    private String generateGitPropertiesFilename;
    private File dotGitDirectory;
    private GitDescribeConfig gitDescribe;
    private int abbrevLength;
    private String format;
    private String prefix;
    private String prefixDot = "";
    private String dateFormat;
    private boolean failOnNoGitDirectory;
    private boolean failOnUnableToExtractRepoInfo;
    private boolean useNativeGit;
    private boolean skip = false;
    private List<String> excludeProperties = Collections.emptyList();
    private Properties properties;
    boolean runningTests = false;
    @NotNull
    LoggerBridge loggerBridge = new MavenLoggerBridge(this.getLog(), true);

    public void execute() throws MojoExecutionException {
        this.loggerBridge.setVerbose(this.verbose);
        if (this.skip) {
            this.log("skip is true, return");
            return;
        }
        if (this.isPomProject(this.project) && this.skipPoms) {
            this.log("isPomProject is true and skipPoms is true, return");
            return;
        }
        this.dotGitDirectory = this.lookupGitDirectory();
        this.throwWhenRequiredDirectoryNotFound(this.dotGitDirectory, this.failOnNoGitDirectory, ".git directory could not be found! Please specify a valid [dotGitDirectory] in your pom.xml");
        if (this.dotGitDirectory == null) {
            this.log("dotGitDirectory is null, aborting execution!");
            return;
        }
        this.log("dotGitDirectory", this.dotGitDirectory.getAbsolutePath());
        try {
            this.properties = this.initProperties();
            String trimmedPrefix = this.prefix.trim();
            this.prefixDot = trimmedPrefix.equals("") ? "" : trimmedPrefix + ".";
            this.loadGitData(this.properties);
            this.loadBuildTimeData(this.properties);
            this.loadShortDescribe(this.properties);
            this.filterNot(this.properties, this.excludeProperties);
            this.logProperties(this.properties);
            if (this.generateGitPropertiesFile) {
                this.generatePropertiesFile(this.properties, this.project.getBasedir(), this.generateGitPropertiesFilename);
            }
            if (this.injectAllReactorProjects) {
                this.appendPropertiesToReactorProjects(this.properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handlePluginFailure(e);
        }
    }

    private void filterNot(Properties properties, @Nullable List<String> exclusions) {
        if (exclusions == null) {
            return;
        }
        List excludePredicates = Lists.transform(exclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldExclude = Predicates.alwaysFalse();
        for (Predicate predicate : excludePredicates) {
            shouldExclude = Predicates.or((Predicate)shouldExclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (!shouldExclude.apply((Object)key)) continue;
            this.loggerBridge.debug("shouldExclude.apply(" + key + ") = " + shouldExclude.apply((Object)key));
            properties.remove(key);
        }
    }

    private void handlePluginFailure(Exception e) throws MojoExecutionException {
        if (this.failOnUnableToExtractRepoInfo) {
            throw new MojoExecutionException("Could not complete Mojo execution...", e);
        }
        this.loggerBridge.error(e.getMessage(), Throwables.getStackTraceAsString((Throwable)e));
    }

    private void appendPropertiesToReactorProjects(@NotNull Properties properties) {
        for (MavenProject mavenProject : this.reactorProjects) {
            Properties mavenProperties = mavenProject.getProperties();
            this.log(mavenProject.getName(), "] project", mavenProject.getName());
            for (Object key : properties.keySet()) {
                mavenProperties.put(key, properties.get(key));
            }
        }
    }

    private void throwWhenRequiredDirectoryNotFound(File dotGitDirectory, Boolean required, String message) throws MojoExecutionException {
        if (required.booleanValue() && this.directoryDoesNotExits(dotGitDirectory)) {
            throw new MojoExecutionException(message);
        }
    }

    @VisibleForTesting
    File lookupGitDirectory() throws MojoExecutionException {
        return new GitDirLocator(this.project, this.reactorProjects).lookupGitDirectory(this.dotGitDirectory);
    }

    private Properties initProperties() throws MojoExecutionException {
        if (this.generateGitPropertiesFile) {
            this.properties = new Properties();
            return this.properties;
        }
        if (!this.runningTests) {
            this.properties = this.project.getProperties();
            return this.properties;
        }
        this.properties = new Properties();
        return this.properties;
    }

    private void logProperties(@NotNull Properties properties) {
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!this.isOurProperty(keyString)) continue;
            this.log("found property", keyString);
        }
    }

    private boolean isOurProperty(@NotNull String keyString) {
        return keyString.startsWith(this.prefixDot);
    }

    void loadBuildTimeData(@NotNull Properties properties) {
        Date commitDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        this.put(properties, BUILD_TIME, smf.format(commitDate));
    }

    void loadShortDescribe(@NotNull Properties properties) {
        String commitDescribe = properties.getProperty(this.prefixDot + COMMIT_DESCRIBE);
        if (commitDescribe != null) {
            int startPos = commitDescribe.indexOf("-g");
            if (startPos > 0) {
                int endPos = commitDescribe.indexOf(45, startPos + 1);
                String commitShortDescribe = endPos < 0 ? commitDescribe.substring(0, startPos) : commitDescribe.substring(0, startPos) + commitDescribe.substring(endPos);
                this.put(properties, COMMIT_SHORT_DESCRIBE, commitShortDescribe);
            } else {
                this.put(properties, COMMIT_SHORT_DESCRIBE, commitDescribe);
            }
        }
    }

    void loadGitData(@NotNull Properties properties) throws IOException, MojoExecutionException {
        if (this.useNativeGit) {
            this.loadGitDataWithNativeGit(properties);
        } else {
            this.loadGitDataWithJGit(properties);
        }
    }

    void loadGitDataWithNativeGit(@NotNull Properties properties) throws IOException, MojoExecutionException {
        File basedir = this.project.getBasedir().getCanonicalFile();
        NativeGitProvider nativeGitProvider = NativeGitProvider.on(basedir).withLoggerBridge(this.loggerBridge).setVerbose(this.verbose).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setGitDescribe(this.gitDescribe);
        nativeGitProvider.loadGitData(properties);
    }

    void loadGitDataWithJGit(@NotNull Properties properties) throws IOException, MojoExecutionException {
        JGitProvider jGitProvider = JGitProvider.on(this.dotGitDirectory).withLoggerBridge(this.loggerBridge).setVerbose(this.verbose).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setGitDescribe(this.gitDescribe);
        jGitProvider.loadGitData(properties);
    }

    void generatePropertiesFile(@NotNull Properties properties, File base, String propertiesFilename) throws IOException {
        OutputStreamWriter outputWriter;
        block5: {
            outputWriter = null;
            File gitPropsFile = this.craftPropertiesOutputFile(base, propertiesFilename);
            try {
                Files.createParentDirs((File)gitPropsFile);
                outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(gitPropsFile), Charset.forName("UTF-8"));
                if ("json".equalsIgnoreCase(this.format)) {
                    this.log("Writing json file to [", gitPropsFile.getAbsolutePath(), "] (for module ", this.project.getName(), ")...");
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeValue((Writer)outputWriter, (Object)properties);
                    break block5;
                }
                this.log("Writing properties file to [", gitPropsFile.getAbsolutePath(), "] (for module ", this.project.getName(), ")...");
                properties.store(outputWriter, "Generated by Git-Commit-Id-Plugin");
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(outputWriter);
                    throw throwable;
                }
            }
        }
        Closeables.closeQuietly((Closeable)outputWriter);
    }

    @VisibleForTesting
    File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }

    boolean isPomProject(@NotNull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    private void put(@NotNull Properties properties, String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log(keyWithPrefix, value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }

    void log(String ... parts) {
        this.loggerBridge.log(parts);
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    private boolean directoryDoesNotExits(File fileLocation) {
        return !this.directoryExists(fileLocation);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
    }

    public void setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
    }

    public void setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void useNativeGit(boolean useNativeGit) {
        this.useNativeGit = useNativeGit;
    }

    public LoggerBridge getLoggerBridge() {
        return this.loggerBridge;
    }
}

