/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import pl.project13.jgit.DescribeCommand;
import pl.project13.jgit.DescribeResult;
import pl.project13.jgit.JGitCommon;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class JGitProvider
extends GitDataProvider {
    private File dotGitDirectory;
    private Repository git;
    private ObjectReader objectReader;
    private RevWalk revWalk;
    private RevCommit headCommit;
    private JGitCommon jGitCommon;

    @NotNull
    public static JGitProvider on(@NotNull File dotGitDirectory, @NotNull LoggerBridge loggerBridge) {
        return new JGitProvider(dotGitDirectory, loggerBridge);
    }

    JGitProvider(@NotNull File dotGitDirectory, @NotNull LoggerBridge loggerBridge) {
        super(loggerBridge);
        this.dotGitDirectory = dotGitDirectory;
        this.jGitCommon = new JGitCommon();
    }

    @NotNull
    public JGitProvider setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    @Override
    protected void init() throws MojoExecutionException {
        this.git = this.getGitRepository();
        this.objectReader = this.git.newObjectReader();
    }

    @Override
    protected String getBuildAuthorName() {
        String userName = this.git.getConfig().getString("user", null, "name");
        return (String)MoreObjects.firstNonNull((Object)userName, (Object)"");
    }

    @Override
    protected String getBuildAuthorEmail() {
        String userEmail = this.git.getConfig().getString("user", null, "email");
        return (String)MoreObjects.firstNonNull((Object)userEmail, (Object)"");
    }

    @Override
    protected void prepareGitToExtractMoreDetailedReproInformation() throws MojoExecutionException {
        try {
            Ref head = this.git.getRef("HEAD");
            if (head == null) {
                throw new MojoExecutionException("Could not get HEAD Ref, are you sure you have set the dotGitDirectory property of this plugin to a valid path?");
            }
            this.revWalk = new RevWalk(this.git);
            ObjectId headObjectId = head.getObjectId();
            if (headObjectId == null) {
                throw new MojoExecutionException("Could not get HEAD Ref, are you sure you have some commits in the dotGitDirectory?");
            }
            this.headCommit = this.revWalk.parseCommit((AnyObjectId)headObjectId);
            this.revWalk.markStart(this.headCommit);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    @Override
    protected String getBranchName() throws IOException {
        String branch = this.git.getBranch();
        return branch;
    }

    @Override
    protected String getGitDescribe() throws MojoExecutionException {
        String gitDescribe = this.getGitDescribe(this.git);
        return gitDescribe;
    }

    @Override
    protected String getCommitId() {
        String commitId = this.headCommit.getName();
        return commitId;
    }

    @Override
    protected String getAbbrevCommitId() throws MojoExecutionException {
        String abbrevCommitId = this.getAbbrevCommitId(this.objectReader, this.headCommit, this.abbrevLength);
        return abbrevCommitId;
    }

    @Override
    protected boolean isDirty() throws MojoExecutionException {
        Git gitObject = Git.wrap((Repository)this.git);
        try {
            return !gitObject.status().call().isClean();
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("Failed to get git status: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected String getCommitAuthorName() {
        String commitAuthor = this.headCommit.getAuthorIdent().getName();
        return commitAuthor;
    }

    @Override
    protected String getCommitAuthorEmail() {
        String commitEmail = this.headCommit.getAuthorIdent().getEmailAddress();
        return commitEmail;
    }

    @Override
    protected String getCommitMessageFull() {
        String fullMessage = this.headCommit.getFullMessage();
        return fullMessage.trim();
    }

    @Override
    protected String getCommitMessageShort() {
        String shortMessage = this.headCommit.getShortMessage();
        return shortMessage.trim();
    }

    @Override
    protected String getCommitTime() {
        long timeSinceEpoch = this.headCommit.getCommitTime();
        Date commitDate = new Date(timeSinceEpoch * 1000L);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(commitDate);
    }

    @Override
    protected String getRemoteOriginUrl() throws MojoExecutionException {
        String remoteOriginUrl = this.git.getConfig().getString("remote", "origin", "url");
        return remoteOriginUrl;
    }

    @Override
    protected String getTags() throws MojoExecutionException {
        try {
            Repository repo = this.getGitRepository();
            ObjectId headId = this.headCommit.toObjectId();
            Collection<String> tags = this.jGitCommon.getTags(repo, headId);
            return Joiner.on((String)",").join(tags);
        }
        catch (GitAPIException e) {
            this.loggerBridge.error("Unable to extract tags from commit: " + this.headCommit.getName() + " (" + ((Object)((Object)e)).getClass().getName() + ")");
            return "";
        }
    }

    @Override
    protected String getClosestTagName() throws MojoExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagName(this.loggerBridge, repo);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    protected String getClosestTagCommitCount() throws MojoExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagCommitCount(this.loggerBridge, repo, this.headCommit);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    protected void finalCleanUp() {
        if (this.revWalk != null) {
            this.revWalk.dispose();
        }
    }

    @VisibleForTesting
    String getGitDescribe(@NotNull Repository repository) throws MojoExecutionException {
        try {
            DescribeResult describeResult = DescribeCommand.on(repository).withLoggerBridge(this.loggerBridge).setVerbose(this.verbose).apply(this.gitDescribe).call();
            return describeResult.toString();
        }
        catch (GitAPIException ex) {
            ex.printStackTrace();
            throw new MojoExecutionException("Unable to obtain git.commit.id.describe information", (Exception)((Object)ex));
        }
    }

    private String getAbbrevCommitId(ObjectReader objectReader, RevCommit headCommit, int abbrevLength) throws MojoExecutionException {
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)headCommit, abbrevLength);
            return abbreviatedObjectId.name();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to abbreviate commit id! You may want to investigate the <abbrevLength/> element in your configuration.", (Exception)e);
        }
    }

    @NotNull
    private Repository getGitRepository() throws MojoExecutionException {
        Repository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not initialize repository...", (Exception)e);
        }
        if (repository == null) {
            throw new MojoExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    @VisibleForTesting
    public void setRepository(Repository git) {
        this.git = git;
    }
}

