/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.log;

import com.google.common.base.Joiner;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;
import org.slf4j.impl.SimpleLoggerFactory;
import pl.project13.maven.git.log.LoggerBridge;

public class MavenLoggerBridge
implements LoggerBridge {
    private Logger logger;
    private boolean verbose;

    public MavenLoggerBridge(Log log, boolean verbose) {
        this.setSimpleLoggerPorperties();
        this.logger = new SimpleLoggerFactory().getLogger(this.getClass().getName());
        this.verbose = verbose;
    }

    private void setSimpleLoggerPorperties() {
        Properties sysProperties = System.getProperties();
        if (!sysProperties.containsKey("org.slf4j.simpleLogger.showThreadName")) {
            System.setProperty("org.slf4j.simpleLogger.showThreadName", String.valueOf(false));
        }
        if (!sysProperties.containsKey("org.slf4j.simpleLogger.levelInBrackets")) {
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", String.valueOf(true));
        }
    }

    @Override
    public void log(Object ... parts) {
        if (this.verbose) {
            this.logger.info(Joiner.on((String)" ").useForNull("null").join(parts));
        }
    }

    @Override
    public void error(Object ... parts) {
        if (this.verbose) {
            this.logger.error(Joiner.on((String)" ").useForNull("null").join(parts));
        }
    }

    @Override
    public void warn(Object ... parts) {
        if (this.verbose) {
            this.logger.warn(Joiner.on((String)" ").useForNull("null").join(parts));
        }
    }

    @Override
    public void debug(Object ... parts) {
        if (this.verbose) {
            this.logger.debug(Joiner.on((String)" ").useForNull("null").join(parts));
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }
}

