/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.log;

import com.google.common.base.Joiner;
import pl.project13.maven.git.log.LoggerBridge;

public class StdOutLoggerBridge
implements LoggerBridge {
    private boolean verbose;

    public StdOutLoggerBridge(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void log(Object ... parts) {
        if (this.verbose) {
            System.out.println("LOG: " + Joiner.on((String)" ").join(parts));
        }
    }

    @Override
    public void error(Object ... parts) {
        if (this.verbose) {
            System.out.println("ERR: " + Joiner.on((String)" ").join(parts));
        }
    }

    @Override
    public void warn(Object ... parts) {
        if (this.verbose) {
            System.out.println("WRN: " + Joiner.on((String)" ").join(parts));
        }
    }

    @Override
    public void debug(Object ... parts) {
        if (this.verbose) {
            System.out.println("DBG: " + Joiner.on((String)" ").join(parts));
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

